% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tag.R
\name{tags}
\alias{tags}
\title{Tags}
\usage{
tags(repo = ".")
}
\arguments{
\item{repo}{a path to a repository or a \code{git_repository}
object. Default is '.'}
}
\value{
list of tags in repository
}
\description{
Tags
}
\examples{
\dontrun{
## Initialize a temporary repository
path <- tempfile(pattern="git2r-")
dir.create(path)
repo <- init(path)

## Create a user
config(repo, user.name="Alice", user.email="alice@example.org")

## Commit a text file
writeLines("Hello world!", file.path(path, "example.txt"))
add(repo, "example.txt")
commit(repo, "First commit message")

## Create tag
tag(repo, "Tagname", "Tag message")

## List tags
tags(repo)
}
}
