% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/contributions.r
\docType{methods}
\name{contributions}
\alias{contributions}
\alias{contributions,missing-method}
\alias{contributions,character-method}
\alias{contributions,git_repository-method}
\title{Contributions}
\usage{
contributions(repo, breaks = c("month", "year", "quarter", "week", "day"),
  by = c("commits", "author"))

\S4method{contributions}{missing}(breaks, by)

\S4method{contributions}{character}(repo, breaks = c("month", "year",
  "quarter", "week", "day"), by = c("commits", "author"))

\S4method{contributions}{git_repository}(repo, breaks = c("month", "year",
  "quarter", "week", "day"), by = c("commits", "author"))
}
\arguments{
\item{repo}{The repository \code{object}
\code{\linkS4class{git_repository}}. If the \code{repo} argument
is missing, the repository is searched for with
\code{\link{discover_repository}} in the current working
directory.}

\item{breaks}{Default is \code{month}. Change to year, quarter,
week or day as necessary.}

\item{by}{Contributions by "commits" or "author". Default is "commits".}
}
\value{
A \code{data.frame} with contributions.
}
\description{
See contributions to a Git repo
}
\examples{
\dontrun{
## Create directories and initialize repositories
path_bare <- tempfile(pattern="git2r-")
path_repo_1 <- tempfile(pattern="git2r-")
path_repo_2 <- tempfile(pattern="git2r-")
dir.create(path_bare)
dir.create(path_repo_1)
dir.create(path_repo_2)
repo_bare <- init(path_bare, bare = TRUE)

## Clone to repo 1 and config user
repo_1 <- clone(path_bare, path_repo_1)
config(repo_1, user.name="Alice", user.email="alice@example.org")

## Add changes to repo 1 and push to bare
writeLines("Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do",
           con = file.path(path_repo_1, "test.txt"))
add(repo_1, "test.txt")
commit(repo_1, "First commit message")

## Add more changes to repo 1
writeLines(c("Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do",
             "eiusmod tempor incididunt ut labore et dolore magna aliqua."),
           con = file.path(path_repo_1, "test.txt"))
add(repo_1, "test.txt")
commit(repo_1, "Second commit message")

## Push to bare
push(repo_1, "origin", "refs/heads/master")

## Clone to repo 2
repo_2 <- clone(path_bare, path_repo_2)
config(repo_2, user.name="Bob", user.email="bob@example.org")

## Add changes to repo 2
writeLines(c("Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do",
             "eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad",
             "minim veniam, quis nostrud exercitation ullamco laboris nisi ut"),
           con = file.path(path_repo_2, "test.txt"))
add(repo_2, "test.txt")
commit(repo_2, "Third commit message")

## Push to bare
push(repo_2, "origin", "refs/heads/master")

## Pull changes to repo 1
pull(repo_1)

## View contributions by day
contributions(repo_1)

## View contributions by author and day
contributions(repo_1, by = "author")
}
}
\keyword{methods}
