% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/remote.r
\docType{methods}
\name{remote_rename}
\alias{remote_rename}
\alias{remote_rename,git_repository,character,character-method}
\title{Rename a remote}
\usage{
remote_rename(repo, oldname, newname)

\S4method{remote_rename}{git_repository,character,character}(repo, oldname,
  newname)
}
\arguments{
\item{repo}{The repository in which the remote should be renamed.}

\item{oldname}{Old name of the remote}

\item{newname}{New name of the remote}
}
\value{
NULL, invisibly
}
\description{
Rename a remote
}
\examples{
\dontrun{
## Initialize a temporary repository
path <- tempfile(pattern="git2r-")
dir.create(path)
repo <- init(path)

## Create a user and commit a file
config(repo, user.name="Alice", user.email="alice@example.org")
writeLines("Hello world!", file.path(path, "example.txt"))
add(repo, "example.txt")
commit(repo, "First commit message")

## Add a remote
remote_add(repo, "playground", "https://example.org/git2r/playground")
remotes(repo)
remote_url(repo, "playground")

## Rename a remote
remote_rename(repo, "playground", "foobar")
remotes(repo)
remote_url(repo, "foobar")

## Remove a remote
remote_remove(repo, "foobar")
remotes(repo)
}
}
\keyword{methods}
