% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/repository.r
\docType{methods}
\name{is_shallow}
\alias{is_shallow}
\alias{is_shallow,git_repository-method}
\alias{is_shallow,missing-method}
\title{Determine if the repository was a shallow clone}
\usage{
is_shallow(repo)

\S4method{is_shallow}{missing}()

\S4method{is_shallow}{git_repository}(repo)
}
\arguments{
\item{repo}{The repository \code{object}
\code{\linkS4class{git_repository}}. If the \code{repo} argument
is missing, the repository is searched for with
\code{\link{discover_repository}} in the current working
directory.}
}
\value{
TRUE if shallow clone, else FALSE
}
\description{
Determine if the repository was a shallow clone
}
\examples{
\dontrun{
## Initialize repository
path_repo_1 <- tempfile(pattern="git2r-")
path_repo_2 <- tempfile(pattern="git2r-")
dir.create(path_repo_1)
dir.create(path_repo_2)
repo_1 <- init(path_repo_1)

## Config user and commit a file
config(repo_1, user.name="Alice", user.email="alice@example.org")

## Write to a file and commit
writeLines("Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do",
           file.path(path_repo_1, "example.txt"))
add(repo_1, "example.txt")
commit(repo_1, "First commit message")

## Change file and commit
writeLines(c("Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do",
             "eiusmod tempor incididunt ut labore et dolore magna aliqua."),
           file.path(path_repo_1, "example.txt"))
add(repo_1, "example.txt")
commit(repo_1, "Second commit message")

## Change file again and commit.
writeLines(c("Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do",
             "eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad",
             "minim veniam, quis nostrud exercitation ullamco laboris nisi ut"),
           file.path(path_repo_1, "example.txt"))
add(repo_1, "example.txt")
commit(repo_1, "Third commit message")

## Clone to second repository
repo_2 <- clone(path_repo_1, path_repo_2)

## Check if it's a shallow clone
is_shallow(repo_2)
}
}
\keyword{methods}

