% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/credential.r
\docType{methods}
\name{cred_ssh_key}
\alias{cred_ssh_key}
\alias{cred_ssh_key,character,character,character-method}
\alias{cred_ssh_key,character,character,missing-method}
\title{Create a new passphrase-protected ssh key credential object}
\usage{
cred_ssh_key(publickey, privatekey, passphrase)

\S4method{cred_ssh_key}{character,character,character}(publickey, privatekey,
  passphrase)

\S4method{cred_ssh_key}{character,character,missing}(publickey, privatekey,
  passphrase)
}
\arguments{
\item{publickey}{The path to the public key of the credential}

\item{privatekey}{The path to the private key of the credential}

\item{passphrase}{The passphrase of the credential}
}
\value{
A S4 \code{cred_ssh_key} object
}
\description{
Create a new passphrase-protected ssh key credential object
}
\examples{
\dontrun{
## Create a ssh key credential object. It can optionally be
## passphrase-protected
cred_ssh_key("~/.ssh/id_rsa.pub", "~/.ssh/id_rsa")
}
}
\keyword{methods}

