\name{gimme}
\alias{gimme}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
Group iterative multiple model estimation.
}
\description{
This function identifies structural equation models for each individual that consist of both group-level and individual-level paths.
}
\usage{
gimme(data, sep, header, out, plot, ar)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{data}{
Path to the directory where the data files are located. Each file must contain one matrix for each individual containing a T (time) by p (number of variables) matrix where the columns represent variables and the rows represent time.
}
  \item{sep}{
The spacing of the data files. "" indicates space-delimited, "/t" indicates tab-delimited, "," indicates comma delimited.
}
  \item{header}{
Logical. Indicate TRUE for data files with a header.
}
  \item{out}{
The path to the directory where the results will be stored. This must be generated by the user prior to running the function.
}
  \item{ar}{
Logical. If TRUE, begins search for group model with autoregressive (AR) paths open. Defaults to FALSE.
}
  \item{plot}{
Logical. If TRUE, graphs depicting relations among variables of interest will automatically be created. Defaults to TRUE.
}
}
\value{
\item{all.elements.summary}{Contains summary information for paths identified at the group- and individual-level.}
\item{all.elements}{Contains information for all paths identified at the group- and individual-level.}
\item{all.fit}{Contains model fit information for individual-level models.}
}
\references{
Gates & Molenaar, 2012
}
\author{
Stephanie Lane
}
\examples{
\dontrun{
gimme.out <- gimme(data = "C:/data100",
             sep = ",",
             header = FALSE,
             out = "C:/data100_gimme_out",
             ar = TRUE,
             plot = TRUE)
}
}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{gimme}

