% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gifti_map_value.R
\name{gifti_map_value}
\alias{gifti_map_value}
\title{Map Values to Triangles from GIFTI}
\usage{
gifti_map_value(
  pointset,
  triangle,
  values,
  indices = seq(nrow(pointset)),
  add_one = TRUE
)
}
\arguments{
\item{pointset}{pointset from GIFTI}

\item{triangle}{triangles from GIFTI}

\item{values}{Values to map to the triangles.  Same length as indices}

\item{indices}{indices to place the values, must be in the range of 1 and
the number of rows of \code{pointset}}

\item{add_one}{Should \code{1} be added to the indices for the triangle?}
}
\value{
A list of coordinates (in triangles) and the corresponding value
mapped to those triangles
}
\description{
Takes values and maps them to the correct triangles in
space.
}
