% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scale-tufte.R
\name{extended_range_breaks_}
\alias{extended_range_breaks_}
\alias{extended_range_breaks}
\title{Pretty axis breaks inclusive of extreme values}
\usage{
extended_range_breaks_(dmin, dmax, n = 5, Q = c(1, 5, 2, 2.5, 4, 3),
  w = c(0.25, 0.2, 0.5, 0.05))

extended_range_breaks(n = 5, ...)
}
\arguments{
\item{dmin}{minimum of the data range}

\item{dmax}{maximum of the data range}

\item{n}{desired number of breaks}

\item{Q}{set of nice numbers}

\item{w}{weights applied to the four optimization components (simplicity, coverage, density, and legibility)}

\item{...}{other arguments passed to \code{extended_range_breaks_}}
}
\value{
For \code{extended_range_breaks}, the vector of axis label locations.
For \code{scales_extended_range_breaks}, a function which takes a single argument, a vector of data, and returns the vector of axis label locations.

A function which returns breaks given a vector.
}
\description{
This function returns pretty axis breaks that always include the extreme  values of the data.
This works by calling the extended Wilkinson algorithm (Talbot et. al, 2010), constrained to solutions interior to the data range.
Then, the minimum and maximum labels are moved to the minimum and maximum of the data range.
}
\details{
\code{extended_range_breaks} implements the algorithm and returns the break values.
\code{scales_extended_range_breaks} uses the conventions of the \pkg{scales} package, and returns a function.
}
\references{
Talbot, J., Lin, S., Hanrahan, P. (2010) An Extension of Wilkinson's Algorithm for Positioning Tick Labels on Axes, InfoVis 2010.
}
\author{
Justin Talbot \email{jtalbot@stanford.edu}, Jeffrey B. Arnold, Baptiste Auguie
}
