% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom-interpolate-tern.R, R/stat-interpolate-tern.R
\docType{data}
\name{geom_interpolate_tern}
\alias{GeomInterpolateTern}
\alias{StatInterpolateTern}
\alias{geom_interpolate_tern}
\alias{stat_interpolate_tern}
\title{Ternary Interpolation}
\format{An object of class \code{StatInterpolateTern} (inherits from \code{Stat}, \code{ggproto}) of length 6.}
\usage{
geom_interpolate_tern(mapping = NULL, data = NULL,
  stat = "InterpolateTern", position = "identity", method = "auto",
  lineend = "butt", linejoin = "round", linemitre = 1, na.rm = FALSE,
  show.legend = NA, inherit.aes = TRUE, formula = value ~ poly(x, y,
  degree = 1), ...)

stat_interpolate_tern(mapping = NULL, data = NULL,
  geom = "InterpolateTern", position = "identity", method = "auto",
  na.rm = FALSE, show.legend = NA, inherit.aes = TRUE, n = 80,
  formula = value ~ poly(x, y, degree = 1), ...)

StatInterpolateTern
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link{aes}} or
\code{\link{aes_}}. If specified and \code{inherit.aes = TRUE} (the
default), is combined with the default mapping at the top level of the
plot. You only need to supply \code{mapping} if there isn't a mapping
defined for the plot.}

\item{data}{A data frame. If specified, overrides the default data frame
defined at the top level of the plot.}

\item{stat}{The statistical transformation to use on the data for this
layer, as a string.}

\item{position}{Position adjustment, either as a string, or the result of
a call to a position adjustment function.}

\item{method}{smoothing method (function) to use, eg. lm, glm, gam, loess,
rlm. For datasets with n < 1000 default is \code{\link{loess}}. For datasets
with 1000 or more observations defaults to gam, see \code{\link[mgcv]{gam}}
for more details.}

\item{lineend}{Line end style (round, butt, square)}

\item{linejoin}{Line join style (round, mitre, bevel)}

\item{linemitre}{Line mitre limit (number greater than 1)}

\item{na.rm}{If \code{FALSE} (the default), removes missing values with
a warning.  If \code{TRUE} silently removes missing values.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link{borders}}.}

\item{formula}{formula to use in smoothing function, eg. \code{y ~ x},
\code{y ~ poly(x, 2)}, \code{y ~ log(x)}}

\item{...}{other arguments passed on to \code{\link{layer}}. There are
  three types of arguments you can use here:

  \itemize{
  \item Aesthetics: to set an aesthetic to a fixed value, like
     \code{color = "red"} or \code{size = 3}.
  \item Other arguments to the layer, for example you override the
    default \code{stat} associated with the layer.
  \item Other arguments passed on to the stat.
  }}

\item{geom}{Use to override the default connection between
\code{geom_smooth} and \code{stat_smooth}.}

\item{n}{number of grid points in each direction}
}
\description{
This is the heavily requested geometry for interpolating between ternary values, results being
rendered using contours on a ternary mesh.
}
\section{Aesthetics}{
 
\Sexpr[results=rd,stage=build]{ggtern:::rd_aesthetics("geom", "InterpolateTern")}
}
\examples{
data(Feldspar)
ggtern(Feldspar,aes(Ab,An,Or,value=T.C)) + 
stat_interpolate_tern(geom="polygon",
                     formula=value~x+y,
                     method=lm,n=100,
                     breaks=seq(0,1000,by=100),
                     aes(fill=..level..),expand=1) +
                     geom_point()
}
\keyword{datasets}

