% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drag-network.R
\name{drag_network}
\alias{drag_network}
\title{Drag the nodes of a network to update the layout of the network}
\usage{
drag_network(p, g = NULL)
}
\arguments{
\item{p}{the network diagram as a ggplot/gg/ggraph object.}

\item{g}{an corresponding igraph object. Default is to extract from the 'ggraph' attribute.}
}
\value{
an updated ggplot/gg/ggraph object
}
\description{
Drag the nodes of a network to update the layout of the network
}
\examples{
\dontrun{
library(igraph)
library(ggraph)

flow_info <- data.frame(from = c(1,2,3,3,4,5,6),
                        to = c(5,5,5,6,7,6,7))
g = graph_from_data_frame(flow_info)
p <- ggraph(g, layout='nicely') + geom_node_point() + geom_edge_link() 
pp <- drag_network(p)
}
}
