% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/title-utils.R
\name{ggtitle_spct}
\alias{ggtitle_spct}
\title{Add title to a spectral plot}
\usage{
ggtitle_spct(object, object.label = deparse(substitute(object)),
  annotations = "title", time.format = "",
  tz = lubridate::tz(getWhenMeasured(object)),
  default.title = "title:objt")
}
\arguments{
\item{object}{generic_spct The spectral object plotted.}

\item{object.label}{character The name of the object being plotted.}

\item{annotations}{character vector Annotations as described for
\code{plot()} methods, values unrelated to title are ignored.}

\item{time.format}{character Format as accepted by \code{\link[base]{strptime}}.}

\item{tz}{character time zone used in labels.}

\item{default.title}{character vector The default used for \code{annotations
= "title"}.}
}
\value{
The return value of \code{ggplot2::ggtitle()}.
}
\description{
Add a title to a spectral plot based on metadata stored in an spectral
object.
}
\details{
\code{ggtitle_spct()} retrieves from object \code{object} metadata and
passes it to \code{ggplot2::ggtitle()} as arguments for \code{title} and
\code{subtitle}. The specification for the tittle is passed as argument
to \code{annotations}, and consists in the keyword \code{title} with optional
modifiers selecting the kind of metatdata to use, separated by colons.
"objt", "class", "what", "when", "where", "inst.name", "inst.sn" and "none"
are recognized as modifiers to "title".
}
\examples{

p <- ggplot(sun.spct) +
  geom_line()

p + ggtitle_spct(sun.spct)
p + ggtitle_spct(sun.spct, annotations = "title:where:when")

}
