% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/axis-utils-filter-spct.R
\name{Tfr_internal_label}
\alias{Tfr_internal_label}
\alias{Tfr_total_label}
\title{Transmittance axis labels}
\usage{
Tfr_internal_label(unit.exponent = 0,
  format = getOption("photobiology.math", default = "R.expression"))

Tfr_total_label(unit.exponent = 0,
  format = getOption("photobiology.math", default = "R.expression"))
}
\arguments{
\item{unit.exponent}{integer}

\item{format}{character string, "R", "R.expresion", "R.character", or
"LaTeX".}
}
\value{
a character string or an R expression.
}
\description{
Generate cps axis labels in SI units,
using SI scale factors. Output can be selected as character, expression (R
default devices) or LaTeX (for tikz device).
}
\examples{

Tfr_internal_label()
Tfr_internal_label(-3)
Tfr_internal_label(format = "R.expression")
Tfr_internal_label(format = "LaTeX")
Tfr_internal_label(-3, format = "LaTeX")


Tfr_total_label()
Tfr_total_label(-2)
Tfr_total_label(-3)
Tfr_total_label(format = "R.expression")
Tfr_total_label(format = "LaTeX")
Tfr_total_label(-2, format = "LaTeX")
Tfr_total_label(-3, format = "LaTeX")

}
