% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/si-prefixes.R
\name{SI_tg_format}
\alias{SI_tg_format}
\alias{SI_tagged}
\title{Formatter for tagged labels using SI multipliers}
\usage{
SI_tg_format(exponent = 0, digits = 3, ...)

SI_tagged(x, exponent = 0, digits = 3, ...)
}
\arguments{
\item{exponent}{numeric Power of 10 to use as multiplier}

\item{digits}{number of significant digits to show}

\item{...}{other arguments passed on to \code{\link{format}}}

\item{x}{a numeric vector to format}
}
\value{
a function with single parameter x, a numeric vector, that
  returns a character vector
}
\description{
The labels generated represent the same numbers, but with trailing zeros
removed/added and compensated by attaching to each label an SI multiplier
"prefix".
}
\note{
If the exponent passed has no SI prefix defined, the exponent will
be adjusted to match one.
}
\examples{
SI_tg_format()(1:10)
SI_tg_format()(runif(10))
SI_tg_format(exponent = 2)(runif(10))
SI_tagged(1:10)
SI_tagged(runif(10))
SI_tagged(runif(10), digits = 2)

}
