% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom-spraster.R
\name{geom_spatial.Raster}
\alias{geom_spatial.Raster}
\alias{ggraster}
\title{Spatial Geometry for Raster* Objects}
\usage{
\method{geom_spatial}{Raster}(data, mapping = NULL, show.legend = TRUE,
  inherit.aes = FALSE, position = "identity", crsfrom = crsfrom,
  crsto = crsto, geom = "raster", stat = "identity", ...)

ggraster(data, mapping = NULL, ...)
}
\arguments{
\item{data}{A Raster* object}

\item{mapping}{A mapping}

\item{show.legend}{Should the legend be shown for this layer?}

\item{inherit.aes}{Should aesthetics be inherited from the base plot?}

\item{position}{The position to apply (should probably always be 'identity')}

\item{crsfrom}{Override the source projection}

\item{crsto}{Override the source projection}

\item{geom}{The geometry to use. Defaults to raster (obviously), but could also
be another value if used with a different stat (e.g. contour)}

\item{stat}{The stat to apply. Defaults to 'identity', but could be something else
like 'contour', \link{stat_rgba} ("rgba"), or \link{stat_project} ("project").}

\item{...}{Further arguments passed to the stat/geom}
}
\value{
A ggplot2 layer
}
\description{
Similar to the \link{geom_spatial} family for Spatial* objects, this method
plots a spatial raster as a spatial raster. Note that projecting (or un-projecting)
this layer will likely result in odd results (namely that geom_raster will not
function properly or at all). As a convenience, \code{ggraster()} is provided,
which replaces the call to \code{coord_map()} from \link{ggspatial} with a call
to \code{coord_fixed()}.
}
\examples{
# standard ggplot syntax
ggplot() + geom_spatial(longlake_osm, aes(fill = band1)) + coord_fixed()
\donttest{
# or use ggraster()
ggraster(longlake_osm, aes(fill = band1))
}

}

