% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom-osm.R
\name{geom_osm}
\alias{geom_osm}
\alias{ggosm}
\title{An Open Street Map Tile Geometry for ggplot2}
\usage{
geom_osm(x = NULL, zoomin = 0, zoom = NULL, type = NULL,
  forcedownload = FALSE, cachedir = NULL, progress = c("text", "none"),
  quiet = TRUE)

ggosm(x = NULL, zoomin = 0, zoom = NULL, type = NULL,
  forcedownload = FALSE, cachedir = NULL, progress = c("text", "none"),
  quiet = TRUE)
}
\arguments{
\item{x}{An object that can be coerced to a bounding box using
\link[rosm]{extract_bbox}, or NULL to use the plot extents to fetch tiles
(probably what you want).}

\item{zoomin}{The amount by which to adjust the automatically calculated zoom
(or manually specified if the \code{zoom} parameter is passed). Use +1 to
zoom in, or -1 to zoom out.}

\item{zoom}{Manually specify the zoom level (not recommended; adjust
\code{zoomin} instead.}

\item{type}{A map type; one of that returned by \link[rosm]{osm.types}. User
defined types are possible by passing any object coercible to type
tile_source (see \link[rosm]{as.tile_source}).}

\item{forcedownload}{\code{TRUE} if cached tiles should be re-downloaded.
Useful if some tiles are corrupted.}

\item{cachedir}{The directory in which tiles should be cached. Defaults to
\code{getwd()/rosm.cache}.}

\item{progress}{A progress bar to use, or "none" to suppress progress updates}

\item{quiet}{Pass \code{FALSE} to see more error messages, particularly if
your tiles do not download/load properly.}
}
\value{
A ggplot2 layer object
}
\description{
This geometry is a lazy version of its conterparts in the ggmap and rosm
packages. All tile downloading/loading/drawing is done at plot draw, such
that a complete backdrop of tiles can be calculated. The arguments are
essentially a wrapper around \link[rosm]{osm.image} and
\link[ggplot2]{annotation_raster} that can plot a specific bounding box or
default to the extents of the plot. The \code{ggosm()}  function is a
shorthand for the common case of \code{ggplot() + geom_osm(...) +
coord_map()}.
}
\examples{

\donttest{
library(prettymapr)
# use as a backdrop for geographical data
cities <- geocode(c("Halifax, NS", "Moncton, NB", "Montreal QC"))
ggplot(cities, aes(lon, lat, shape = query)) + geom_osm() +
  geom_point() + coord_map()

# use ggosm() shorthand
ggosm() + geom_point(aes(lon, lat), cities)

# use on its own with a bounding box
ggosm(searchbbox("vermont, USA"))

# use alternative map types (see rosm::osm.types())
ggosm(type = "stamenwatercolor") + geom_point(aes(lon, lat), cities)
}


}

