% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scatter_plots.R
\name{plot_scatter}
\alias{plot_scatter}
\title{A histogram of a single variable from a single target}
\usage{
plot_scatter(
  output,
  x_parameter,
  x_dimension = 1,
  y_parameter,
  y_dimension = 1,
  target = NULL,
  external_target = NULL,
  use_initial_points = TRUE,
  use_weights = TRUE,
  max_size = 1,
  alpha = 0.1,
  xlimits = NULL,
  ylimits = NULL,
  default_title = FALSE
)
}
\arguments{
\item{output}{Output from the SMC or EnK algorithm.}

\item{x_parameter}{The parameter indexed by the x-axis.}

\item{x_dimension}{(optional) The dimension of the x-parameter we wish to histogram. (default is 1)}

\item{y_parameter}{The parameter indexed by the y-axis.}

\item{y_dimension}{(optional) The dimension of the y-parameter we wish to histogram. (default is 1)}

\item{target}{(optional) The index of the target we wish to plot. (default is to use all targets)}

\item{external_target}{(optional) The index of the external target to plot. (default is to use all external targets, or to ignore if the column is not present)}

\item{use_initial_points}{(optional) If target is not specified and this argument is TRUE, will add the initial unweighted proposed points to the output to be plotted. (default is TRUE)}

\item{use_weights}{(optional) If FALSE, will ignore particle weights in the scatter plot. If TRUE, will use the particle weights. (defaults to TRUE)}

\item{max_size}{(optional) The maximum size of the points in the plot. (default=1)}

\item{alpha}{(optional) The transparency of the points in the plot. (default=0.1)}

\item{xlimits}{(optional) Input of the form c(start,end), which specifies the ends of the x-axis.}

\item{ylimits}{(optional) Input of the form c(start,end), which specifies the ends of the y-axis.}

\item{default_title}{(optional) If TRUE, will provide a default title for the figure. If FALSE, no title is used. (defaults to FALSE)}
}
\value{
A scatter plot in a ggplot figure.
}
\description{
A histogram of a single variable from a single target
}
