% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggsem_app.R
\name{ggsem}
\alias{ggsem}
\title{Launch ggsem Shiny Application}
\usage{
ggsem(
  object = NULL,
  model_obj = NULL,
  model = NULL,
  metadata = NULL,
  type = "sem",
  session = "sem",
  center_x = NULL,
  center_y = NULL,
  width = NULL,
  height = NULL,
  random_seed = NULL,
  group_id = NULL,
  group_level = NULL
)
}
\arguments{
\item{object}{Optional visualization object. Supported types include:
- For SEM: `lavaan`, `qgraph` (from semPaths), `sem_graph` (tidySEM),
  `MxRAMModel` (OpenMx), `mplusObject`, `grViz` (diagrammeR)
- For networks: `igraph`, `network`, `qgraph`}

\item{model_obj}{Optional model object to accompany visualization objects.
Required for some object types like `sem_graph` (tidySEM) for SEM visualizations.}

\item{model}{Same with model_obj}

\item{metadata}{Path to a saved RDS file containing a previous ggsem workflow session or RDS-read object.
When provided, the app will load this session data instead of creating a new one.}

\item{type}{Type of analysis: 'sem' for structural equation modeling or
'network' for network analysis. Default is 'sem'.}

\item{session}{Initial session type (element type) when app launches. Either 'point', 'line', 'annotation', 'loop', 'sem' or 'network'.
Default is 'sem'.}

\item{center_x}{X-coordinate for the center of the visualization. If NULL,
defaults to 0.}

\item{center_y}{Y-coordinate for the center of the visualization. If NULL,
defaults to 0.}

\item{width}{Width of the visualization area. If NULL, defaults to 25.}

\item{height}{Height of the visualization area. If NULL, defaults to 25.}

\item{random_seed}{Random seed for reproducibility of layouts. If NULL,
uses current time in milliseconds.}

\item{group_id}{Identifier for grouping in multi-group models}

\item{group_level}{Level for grouping in multi-group models as in original data file or model object}
}
\value{
Launches a Shiny application. Does not return a value.
}
\description{
Main function to launch the ggsem Shiny application for interactive
network and structural equation modeling visualization. The app can be
started with pre-existing objects or used to create visualizations from scratch.
}
\details{
The ggsem Shiny application provides an interactive interface for:
- Visualizing and customizing SEM path diagrams
- Creating and modifying network visualizations
- Adjusting node/edge aesthetics, layouts, and annotations
- Exporting high-quality publication-ready graphics

When starting with an object, the app will pre-load the visualization
and allow further customization. When starting without an object, users
can upload data or use built-in examples.
}
\section{Supported Object Types}{

\strong{SEM Objects:}
\itemize{
  \item \code{lavaan}: Fitted lavaan models
  \item \code{qgraph}: semPaths objects from lavaan models
  \item \code{sem_graph}: tidySEM objects
  \item \code{MxRAMModel}: OpenMx models
  \item \code{mplusObject}: Mplus models
  \item \code{grViz}: diagrammeR objects from lavaanPlot
}

\strong{Network Objects:}
\itemize{
  \item \code{igraph}: igraph network objects
  \item \code{network}: network package objects
  \item \code{qgraph}: qgraph network objects
}
}

\examples{
\dontrun{
# Launch app without pre-existing objects
ggsem()

# Launch app with a lavaan model
library(lavaan)
model <- ' visual  =~ x1 + x2 + x3
           textual =~ x4 + x5 + x6
           speed   =~ x7 + x8 + x9 '
fit <- cfa(model, data = HolzingerSwineford1939)
ggsem(object = fit)

# Launch app with an igraph network
library(igraph)
g <- make_ring(10)
ggsem(object = g, type = "network", session = "network")

# Launch app with custom dimensions
ggsem(object = g, type = "network", center_x = 10, center_y = 10, width = 30, height = 30)


# Launch app with no input
ggsem()
}
}
