% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layout_partition.R
\name{layout_tbl_graph_partition}
\alias{layout_tbl_graph_partition}
\title{Calculate nodes as areas dividing their parent}
\usage{
layout_tbl_graph_partition(graph, weight = NULL, circular = FALSE,
  height = NULL, sort.by = NULL, direction = "out", offset = pi/2,
  const.area = TRUE)
}
\arguments{
\item{graph}{An \code{tbl_graph} object}

\item{weight}{An optional node variable to use as weight. Will only affect
the weight of leaf nodes as the weight of non-leaf nodes are derived from
their children.}

\item{circular}{Logical. Should the layout be transformed to a circular
representation. If \code{TRUE} the resulting layout will be a sunburst
diagram.}

\item{height}{An optional node variable to use as height. If \code{NULL}
all nodes will be given a height of 1.}

\item{sort.by}{The name of a node variable to sort the nodes by.}

\item{direction}{The direction of the tree in the graph. \code{'out'} (default)
means that parents point towards their children, while \code{'in'} means that
children point towards their parent.}

\item{offset}{If \code{circular = TRUE}, where should it begin. Defaults to
\code{pi/2} which is equivalent to 12 o'clock.}

\item{const.area}{Logical. Should 'height' be scaled for area proportionality
when using \code{circular = TRUE}. Defaults to \code{TRUE}.}
}
\value{
If \code{circular = FALSE} A data.frame with the columns \code{x},
\code{y}, \code{width}, \code{height}, \code{leaf},
\code{depth}, \code{circular} as well as any information stored as node
variables in the tbl_graph object.
If \code{circular = TRUE} A data.frame with the columns \code{x}, \code{y},
\code{r0}, \code{r}, \code{start}, \code{end}, \code{leaf},
\code{depth}, \code{circular} as well as any information stored as node
variables in the tbl_graph object.
}
\description{
The partition layout is a way to show hierarchical data in the same way as
\code{\link[=layout_tbl_graph_treemap]{layout_tbl_graph_treemap()}}. Instead of subdividing the parent area
the partition layout shows the division of a nodes children next to the area
of the node itself. As such the node positions will be very reminiscent of
a reingold-tilford tree layout but by plotting nodes as areas it better
communicate the total weight of a node by summing up all its children.
Often partition layouts are called icicle plots or sunburst diagrams (in case
a radial transform is applied).
}
\note{
partition is a layout intended for trees, that is, graphs where nodes
only have one parent and zero or more children. If the provided graph does
not fit this format an attempt to convert it to such a format will be made.
}
\references{
Kruskal, J. B., Landwehr, J. M. (1983). \emph{Icicle Plots: Better Displays
for Hierarchical Clustering}. American Statistician Vol 37(2), 162-168.
https://doi.org/10.2307/2685881
}
\seealso{
Other layout_tbl_graph_*: \code{\link{layout_tbl_graph_auto}},
  \code{\link{layout_tbl_graph_backbone}},
  \code{\link{layout_tbl_graph_centrality}},
  \code{\link{layout_tbl_graph_circlepack}},
  \code{\link{layout_tbl_graph_dendrogram}},
  \code{\link{layout_tbl_graph_eigen}},
  \code{\link{layout_tbl_graph_fabric}},
  \code{\link{layout_tbl_graph_focus}},
  \code{\link{layout_tbl_graph_hive}},
  \code{\link{layout_tbl_graph_igraph}},
  \code{\link{layout_tbl_graph_linear}},
  \code{\link{layout_tbl_graph_manual}},
  \code{\link{layout_tbl_graph_matrix}},
  \code{\link{layout_tbl_graph_pmds}},
  \code{\link{layout_tbl_graph_stress}},
  \code{\link{layout_tbl_graph_treemap}},
  \code{\link{layout_tbl_graph_unrooted}}
}
\concept{layout_tbl_graph_*}
