% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stat-dens2d-labels.r
\name{stat_dens2d_labels}
\alias{stat_dens2d_labels}
\title{Replace labels in data based on 2D density}
\usage{
stat_dens2d_labels(
  mapping = NULL,
  data = NULL,
  geom = "text",
  position = "identity",
  ...,
  keep.fraction = 0.1,
  keep.number = Inf,
  keep.sparse = TRUE,
  invert.selection = FALSE,
  h = NULL,
  n = NULL,
  label.fill = "",
  na.rm = TRUE,
  show.legend = FALSE,
  inherit.aes = TRUE
)
}
\arguments{
\item{mapping}{The aesthetic mapping, usually constructed with
\code{\link[ggplot2]{aes}} or \code{\link[ggplot2]{aes_}}. Only needs
to be set at the layer level if you are overriding the plot defaults.}

\item{data}{A layer specific dataset - only needed if you want to override
the plot defaults.}

\item{geom}{The geometric object to use display the data.}

\item{position}{The position adjustment to use for overlapping points on this
layer}

\item{...}{other arguments passed on to \code{\link[ggplot2]{layer}}. This
can include aesthetics whose values you want to set, not map. See
\code{\link[ggplot2]{layer}} for more details.}

\item{keep.fraction}{numeric [0..1]. The fraction of the observations (or
rows) in \code{data} to be retained.}

\item{keep.number}{integer Set the maximum number of observations to retain,
effective only if obeying \code{keep.fraction} would result in a larger
number.}

\item{keep.sparse}{logical If \code{TRUE}, the default, observations from the
more sparse regions are retained, if \code{FALSE} those from the densest
regions.}

\item{invert.selection}{logical If \code{TRUE}, the complement of the
selected rows are returned.}

\item{h}{vector of bandwidths for x and y directions. Defaults to normal
reference bandwidth (see bandwidth.nrd). A scalar value will be taken to
apply to both directions.}

\item{n}{Number of grid points in each direction. Can be scalar or a length-2
integer vector}

\item{label.fill}{character vector of length 1 or a function.}

\item{na.rm}{a logical value indicating whether NA values should be stripped
before the computation proceeds.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped. \code{FALSE}
never includes, and \code{TRUE} always includes.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics, rather
than combining with them. This is most useful for helper functions that
define both data and aesthetics and shouldn't inherit behaviour from the
default plot specification, e.g. \code{\link[ggplot2]{borders}}.}
}
\value{
A plot layer instance. Using as output \code{data} the input
  \code{data} after value substitution based on a 2D the filtering criterion.
}
\description{
\code{stat_dens2d_labels()} Sets values mapped to the
  \code{label} aesthetic to \code{""} or a user provided character string
  based on the local density in regions of a plot panel. Its main use is
  together with repulsive geoms from package \code{\link[ggrepel]{ggrepel}}.
  If there is no mapping to \code{label} in \code{data}, the mapping is set
  to \code{rownames(data)}, with a message.
}
\details{
\code{stat_dens2d_labels()} is designed to work together with
  statistics from package 'ggrepel'. To avoid text labels being plotted over
  unlabelled points the corresponding rows in data need to be retained but
  labels replaced with the empty character string, \code{""}. This makes
  \code{\link{stat_dens2d_filter}} unsuitable for the task. Non-the-less
  \code{stat_dens2d_labels()} could be useful in some other cases, as the
  substitution character string can be set by the user.
}
\examples{

random_string <-
  function(len = 6) {
    paste(sample(letters, len, replace = TRUE), collapse = "")
  }

# Make random data.
set.seed(1001)
d <- tibble::tibble(
  x = rnorm(100),
  y = rnorm(100),
  group = rep(c("A", "B"), c(50, 50)),
  lab = replicate(100, { random_string() })
)

# using defaults
ggplot(data = d, aes(x, y, label = lab)) +
  geom_point() +
  stat_dens2d_labels()

ggplot(data = d, aes(x, y, label = lab)) +
  geom_point() +
  stat_dens2d_labels(geom = "text_linked",
                     position = position_nudge_center(x = 0.1, y = 0.1,
                                                      center_x = mean,
                                                      center_y = mean),
                     vjust = "outward_mean", hjust = "outward_mean") +
  expand_limits(x = c(-4, 4.5))

ggrepel.installed <- requireNamespace("ggrepel", quietly = TRUE)
if (ggrepel.installed) {
  library(ggrepel)

  ggplot(data = d, aes(x, y, label = lab, colour = group)) +
    geom_point() +
    stat_dens2d_labels(geom = "text_repel")

  ggplot(data = d, aes(x, y, label = lab, colour = group)) +
    geom_point() +
    stat_dens2d_labels(geom = "text_repel", label.fill = NA)

# we keep labels starting with "a" across the whole plot, but all in sparse
# regions. To achieve this we pass as argument to label.fill a fucntion
# instead of a character string.
  label.fun <- function(x) {ifelse(grepl("^a", x), x, "")}
  ggplot(data = d, aes(x, y, label = lab, colour = group)) +
    geom_point() +
    stat_dens2d_labels(geom = "text_repel", label.fill = label.fun)
}
# Using geom_debug() we can see that all 100 rows in \code{d} are
# returned. But only those labelled in the previous example still contain
# the original labels.

gginnards.installed <- requireNamespace("gginnards", quietly = TRUE)
if (gginnards.installed) {
  library(gginnards)

  ggplot(data = d, aes(x, y, label = lab)) +
    geom_point() +
    stat_dens2d_labels(geom = "debug")
}

}
\seealso{
\code{\link[MASS]{kde2d}} used internally.

Other statistics returning a subset of data: 
\code{\link{stat_dens1d_filter}()},
\code{\link{stat_dens1d_labels}()},
\code{\link{stat_dens2d_filter}()}
}
\concept{statistics returning a subset of data}
