% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stat-peaks.R
\name{find_peaks}
\alias{find_peaks}
\title{Find local maxima or global maximum (peaks).}
\usage{
find_peaks(x, ignore_threshold = 0, span = 3, strict = TRUE)
}
\arguments{
\item{x}{numeric array}

\item{ignore_threshold}{numeric value between 0.0 and 1.0 indicating the size
threshold below which peaks will be ignored.}

\item{span}{a peak is defined as an element in a sequence which is greater
than all other elements within a window of width span centered at that
element. The default value is 3, meaning that a peak is bigger than both of
its neighbors. Default: 3.}

\item{strict}{logical flag: if TRUE, an element must be strictly greater than
all other values in its window to be considered a peak. Default: TRUE.}
}
\value{
A vector of logical values. Values that are TRUE
  correspond to local peaks in the data.
}
\description{
This method finds peaks (local maxima) in a spectrum, using a user selectable
span and size threshold relative to the tallest peak (global maximum). This
is a wrapper built on top of function peaks from package splus2R.
}
\details{
This function is a wrapper built on function
  \code{\link[splus2R]{peaks}} from \pkg{splus2R} and handles non-finite
  (including NA) values differently than \code{peaks}, instead of giving an
  error they are replaced with the smallest finite value in \code{x}.
}
\seealso{
\code{\link[splus2R]{peaks}}

Other peaks.and.valleys.functions: \code{\link{stat_peaks}}
}
\keyword{internal}

