% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scale-date.R
\name{scale_date}
\alias{scale_x_date}
\alias{scale_y_date}
\alias{scale_x_datetime}
\alias{scale_y_datetime}
\alias{scale_x_time}
\alias{scale_y_time}
\title{Position scales for date/time data}
\usage{
scale_x_date(
  name = waiver(),
  breaks = waiver(),
  date_breaks = waiver(),
  labels = waiver(),
  date_labels = waiver(),
  minor_breaks = waiver(),
  date_minor_breaks = waiver(),
  limits = NULL,
  expand = waiver(),
  oob = censor,
  guide = waiver(),
  position = "bottom",
  sec.axis = waiver()
)

scale_y_date(
  name = waiver(),
  breaks = waiver(),
  date_breaks = waiver(),
  labels = waiver(),
  date_labels = waiver(),
  minor_breaks = waiver(),
  date_minor_breaks = waiver(),
  limits = NULL,
  expand = waiver(),
  oob = censor,
  guide = waiver(),
  position = "left",
  sec.axis = waiver()
)

scale_x_datetime(
  name = waiver(),
  breaks = waiver(),
  date_breaks = waiver(),
  labels = waiver(),
  date_labels = waiver(),
  minor_breaks = waiver(),
  date_minor_breaks = waiver(),
  timezone = NULL,
  limits = NULL,
  expand = waiver(),
  oob = censor,
  guide = waiver(),
  position = "bottom",
  sec.axis = waiver()
)

scale_y_datetime(
  name = waiver(),
  breaks = waiver(),
  date_breaks = waiver(),
  labels = waiver(),
  date_labels = waiver(),
  minor_breaks = waiver(),
  date_minor_breaks = waiver(),
  timezone = NULL,
  limits = NULL,
  expand = waiver(),
  oob = censor,
  guide = waiver(),
  position = "left",
  sec.axis = waiver()
)

scale_x_time(
  name = waiver(),
  breaks = waiver(),
  minor_breaks = waiver(),
  labels = waiver(),
  limits = NULL,
  expand = waiver(),
  oob = censor,
  na.value = NA_real_,
  guide = waiver(),
  position = "bottom",
  sec.axis = waiver()
)

scale_y_time(
  name = waiver(),
  breaks = waiver(),
  minor_breaks = waiver(),
  labels = waiver(),
  limits = NULL,
  expand = waiver(),
  oob = censor,
  na.value = NA_real_,
  guide = waiver(),
  position = "left",
  sec.axis = waiver()
)
}
\arguments{
\item{name}{The name of the scale. Used as the axis or legend title. If
\code{waiver()}, the default, the name of the scale is taken from the first
mapping used for that aesthetic. If \code{NULL}, the legend title will be
omitted.}

\item{breaks}{One of:
\itemize{
\item \code{NULL} for no breaks
\item \code{waiver()} for the breaks specified by \code{date_breaks}
\item A \code{Date}/\code{POSIXct} vector giving positions of breaks
\item A function that takes the limits as input and returns breaks as output
}}

\item{date_breaks}{A string giving the distance between breaks like "2
weeks", or "10 years". If both \code{breaks} and \code{date_breaks} are
specified, \code{date_breaks} wins. Valid specifications are 'sec', 'min',
'hour', 'day', 'week', 'month' or 'year', optionally followed by 's'.}

\item{labels}{One of:
\itemize{
\item \code{NULL} for no labels
\item \code{waiver()} for the default labels computed by the
transformation object
\item A character vector giving labels (must be same length as \code{breaks})
\item An expression vector (must be the same length as breaks). See ?plotmath for details.
\item A function that takes the breaks as input and returns labels
as output. Also accepts rlang \link[rlang:as_function]{lambda} function
notation.
}}

\item{date_labels}{A string giving the formatting specification for the
labels. Codes are defined in \code{\link[=strftime]{strftime()}}. If both \code{labels}
and \code{date_labels} are specified, \code{date_labels} wins.}

\item{minor_breaks}{One of:
\itemize{
\item \code{NULL} for no breaks
\item \code{waiver()} for the breaks specified by \code{date_minor_breaks}
\item A \code{Date}/\code{POSIXct} vector giving positions of minor breaks
\item A function that takes the limits as input and returns minor breaks as
output
}}

\item{date_minor_breaks}{A string giving the distance between minor breaks
like "2 weeks", or "10 years". If both \code{minor_breaks} and
\code{date_minor_breaks} are specified, \code{date_minor_breaks} wins. Valid
specifications are 'sec', 'min', 'hour', 'day', 'week', 'month' or 'year',
optionally followed by 's'.}

\item{limits}{One of:
\itemize{
\item \code{NULL} to use the default scale range
\item A numeric vector of length two providing limits of the scale.
Use \code{NA} to refer to the existing minimum or maximum
\item A function that accepts the existing (automatic) limits and returns
new limits. Also accepts rlang \link[rlang:as_function]{lambda} function
notation.
Note that setting limits on positional scales will \strong{remove} data outside of the limits.
If the purpose is to zoom, use the limit argument in the coordinate system
(see \code{\link[=coord_cartesian]{coord_cartesian()}}).
}}

\item{expand}{For position scales, a vector of range expansion constants used to add some
padding around the data to ensure that they are placed some distance
away from the axes. Use the convenience function \code{\link[=expansion]{expansion()}}
to generate the values for the \code{expand} argument. The defaults are to
expand the scale by 5\% on each side for continuous variables, and by
0.6 units on each side for discrete variables.}

\item{oob}{One of:
\itemize{
\item Function that handles limits outside of the scale limits
(out of bounds). Also accepts rlang \link[rlang:as_function]{lambda}
function notation.
\item The default (\code{\link[scales:oob]{scales::censor()}}) replaces out of
bounds values with \code{NA}.
\item \code{\link[scales:oob]{scales::squish()}} for squishing out of bounds values into range.
\item \code{\link[scales:oob]{scales::squish_infinite()}} for squishing infinite values into range.
}}

\item{guide}{A function used to create a guide or its name. See
\code{\link[=guides]{guides()}} for more information.}

\item{position}{For position scales, The position of the axis.
\code{left} or \code{right} for y axes, \code{top} or \code{bottom} for x axes.}

\item{sec.axis}{\code{\link[=sec_axis]{sec_axis()}} is used to specify a secondary axis.}

\item{timezone}{The timezone to use for display on the axes. The default
(\code{NULL}) uses the timezone encoded in the data.}

\item{na.value}{Missing values will be replaced with this value.}
}
\description{
These are the default scales for the three date/time class. These will
usually be added automatically. To override manually, use
\verb{scale_*_date} for dates (class \code{Date}),
\verb{scale_*_datetime} for datetimes (class \code{POSIXct}), and
\verb{scale_*_time} for times (class \code{hms}).
}
\examples{
last_month <- Sys.Date() - 0:29
set.seed(1)
df <- data.frame(
  date = last_month,
  price = runif(30)
)
base <- ggplot(df, aes(date, price)) +
  geom_line()

# The date scale will attempt to pick sensible defaults for
# major and minor tick marks. Override with date_breaks, date_labels
# date_minor_breaks arguments.
base + scale_x_date(date_labels = "\%b \%d")
base + scale_x_date(date_breaks = "1 week", date_labels = "\%W")
base + scale_x_date(date_minor_breaks = "1 day")

# Set limits
base + scale_x_date(limits = c(Sys.Date() - 7, NA))

}
\seealso{
\code{\link[=sec_axis]{sec_axis()}} for how to specify secondary axes

The \link[=aes_position]{position documentation}.

Other position scales: 
\code{\link{scale_x_binned}()},
\code{\link{scale_x_continuous}()},
\code{\link{scale_x_discrete}()}
}
\concept{position scales}
