% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scale-date.R
\name{datetime_scale}
\alias{datetime_scale}
\title{Date/time scale constructor}
\usage{
datetime_scale(
  aesthetics,
  trans,
  palette,
  breaks = pretty_breaks(),
  minor_breaks = waiver(),
  labels = waiver(),
  date_breaks = waiver(),
  date_labels = waiver(),
  date_minor_breaks = waiver(),
  timezone = NULL,
  guide = "legend",
  ...
)
}
\arguments{
\item{aesthetics}{The names of the aesthetics that this scale works with.}

\item{trans}{For date/time scales, the name of a date/time transformation or
the object itself. Built-in transformations include "hms", "date" and "time".}

\item{palette}{A palette function that when called with a numeric vector with
values between 0 and 1 returns the corresponding output values
(e.g., \code{\link[scales:area_pal]{scales::area_pal()}}).}

\item{breaks}{One of:
\itemize{
\item \code{NULL} for no breaks
\item \code{waiver()} for the breaks specified by \code{date_breaks}
\item A \code{Date}/\code{POSIXct} vector giving positions of breaks
\item A function that takes the limits as input and returns breaks as output
}}

\item{minor_breaks}{One of:
\itemize{
\item \code{NULL} for no breaks
\item \code{waiver()} for the breaks specified by \code{date_minor_breaks}
\item A \code{Date}/\code{POSIXct} vector giving positions of minor breaks
\item A function that takes the limits as input and returns minor breaks as
output
}}

\item{labels}{One of:
\itemize{
\item \code{NULL} for no labels
\item \code{waiver()} for the default labels computed by the
transformation object
\item A character vector giving labels (must be same length as \code{breaks})
\item An expression vector (must be the same length as breaks). See ?plotmath for details.
\item A function that takes the breaks as input and returns labels
as output. Also accepts rlang \link[rlang:as_function]{lambda} function
notation.
}}

\item{date_breaks}{A string giving the distance between breaks like "2
weeks", or "10 years". If both \code{breaks} and \code{date_breaks} are
specified, \code{date_breaks} wins. Valid specifications are 'sec', 'min',
'hour', 'day', 'week', 'month' or 'year', optionally followed by 's'.}

\item{date_labels}{A string giving the formatting specification for the
labels. Codes are defined in \code{\link[=strftime]{strftime()}}. If both \code{labels}
and \code{date_labels} are specified, \code{date_labels} wins.}

\item{date_minor_breaks}{A string giving the distance between minor breaks
like "2 weeks", or "10 years". If both \code{minor_breaks} and
\code{date_minor_breaks} are specified, \code{date_minor_breaks} wins. Valid
specifications are 'sec', 'min', 'hour', 'day', 'week', 'month' or 'year',
optionally followed by 's'.}

\item{timezone}{The timezone to use for display on the axes. The default
(\code{NULL}) uses the timezone encoded in the data.}

\item{guide}{A function used to create a guide or its name. See
\code{\link[=guides]{guides()}} for more information.}

\item{...}{
  Arguments passed on to \code{\link[=continuous_scale]{continuous_scale}}
  \describe{
    \item{\code{scale_name}}{The name of the scale that should be used for error messages
associated with this scale.}
    \item{\code{name}}{The name of the scale. Used as the axis or legend title. If
\code{waiver()}, the default, the name of the scale is taken from the first
mapping used for that aesthetic. If \code{NULL}, the legend title will be
omitted.}
    \item{\code{n.breaks}}{An integer guiding the number of major breaks. The algorithm
may choose a slightly different number to ensure nice break labels. Will
only have an effect if \code{breaks = waiver()}. Use \code{NULL} to use the default
number of breaks given by the transformation.}
    \item{\code{limits}}{One of:
\itemize{
\item \code{NULL} to use the default scale range
\item A numeric vector of length two providing limits of the scale.
Use \code{NA} to refer to the existing minimum or maximum
\item A function that accepts the existing (automatic) limits and returns
new limits. Also accepts rlang \link[rlang:as_function]{lambda} function
notation.
Note that setting limits on positional scales will \strong{remove} data outside of the limits.
If the purpose is to zoom, use the limit argument in the coordinate system
(see \code{\link[=coord_cartesian]{coord_cartesian()}}).
}}
    \item{\code{rescaler}}{A function used to scale the input values to the
range [0, 1]. This is always \code{\link[scales:rescale]{scales::rescale()}}, except for
diverging and n colour gradients (i.e., \code{\link[=scale_colour_gradient2]{scale_colour_gradient2()}},
\code{\link[=scale_colour_gradientn]{scale_colour_gradientn()}}). The \code{rescaler} is ignored by position
scales, which always use \code{\link[scales:rescale]{scales::rescale()}}. Also accepts rlang
\link[rlang:as_function]{lambda} function notation.}
    \item{\code{oob}}{One of:
\itemize{
\item Function that handles limits outside of the scale limits
(out of bounds). Also accepts rlang \link[rlang:as_function]{lambda}
function notation.
\item The default (\code{\link[scales:oob]{scales::censor()}}) replaces out of
bounds values with \code{NA}.
\item \code{\link[scales:oob]{scales::squish()}} for squishing out of bounds values into range.
\item \code{\link[scales:oob]{scales::squish_infinite()}} for squishing infinite values into range.
}}
    \item{\code{na.value}}{Missing values will be replaced with this value.}
    \item{\code{expand}}{For position scales, a vector of range expansion constants used to add some
padding around the data to ensure that they are placed some distance
away from the axes. Use the convenience function \code{\link[=expansion]{expansion()}}
to generate the values for the \code{expand} argument. The defaults are to
expand the scale by 5\% on each side for continuous variables, and by
0.6 units on each side for discrete variables.}
    \item{\code{position}}{For position scales, The position of the axis.
\code{left} or \code{right} for y axes, \code{top} or \code{bottom} for x axes.}
    \item{\code{super}}{The super class to use for the constructed scale}
  }}
}
\description{
Date/time scale constructor
}
\keyword{internal}
