% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scale-colour.R, R/zxx.R
\name{scale_colour_continuous}
\alias{scale_colour_continuous}
\alias{scale_fill_continuous}
\alias{scale_colour_binned}
\alias{scale_fill_binned}
\alias{scale_color_continuous}
\alias{scale_color_binned}
\title{Continuous and binned colour scales}
\usage{
scale_colour_continuous(..., type = getOption("ggplot2.continuous.colour"))

scale_fill_continuous(..., type = getOption("ggplot2.continuous.fill"))

scale_colour_binned(..., type = getOption("ggplot2.binned.colour"))

scale_fill_binned(..., type = getOption("ggplot2.binned.fill"))
}
\arguments{
\item{...}{Additional parameters passed on to the scale type}

\item{type}{One of the following:
\itemize{
\item "gradient" (the default)
\item "viridis"
\item A function that returns a continuous colour scale.
}}
}
\description{
The scales \code{scale_colour_continuous()} and \code{scale_fill_continuous()} are
the default colour scales ggplot2 uses when continuous data values are
mapped onto the \code{colour} or \code{fill} aesthetics, respectively. The scales
\code{scale_colour_binned()} and \code{scale_fill_binned()} are equivalent scale
functions that assign discrete color bins to the continuous values
instead of using a continuous color spectrum.
}
\details{
All these colour scales use the \code{\link[=options]{options()}} mechanism to determine
default settings. Continuous colour scales default to the values of the
\code{ggplot2.continuous.colour} and \code{ggplot2.continuous.fill} options, and
binned colour scales default to the values of the \code{ggplot2.binned.colour}
and \code{ggplot2.binned.fill} options. These option values default to
\code{"gradient"}, which means that the scale functions actually used are
\code{\link[=scale_colour_gradient]{scale_colour_gradient()}}/\code{\link[=scale_fill_gradient]{scale_fill_gradient()}} for continuous scales and
\code{\link[=scale_colour_steps]{scale_colour_steps()}}/\code{\link[=scale_fill_steps]{scale_fill_steps()}} for binned scales.
Alternative option values are \code{"viridis"} or a different scale function.
See description of the \code{type} argument for details.

Note that the binned colour scales will use the settings of
\code{ggplot2.continuous.colour} and \code{ggplot2.continuous.fill} as fallback,
respectively, if \code{ggplot2.binned.colour} or \code{ggplot2.binned.fill} are
not set.

These scale functions are meant to provide simple defaults. If
you want to manually set the colors of a scale, consider using
\code{\link[=scale_colour_gradient]{scale_colour_gradient()}} or \code{\link[=scale_colour_steps]{scale_colour_steps()}}.
}
\section{Color Blindness}{

Many color palettes derived from RGB combinations (like the "rainbow" color
palette) are not suitable to support all viewers, especially those with
color vision deficiencies. Using \code{viridis} type, which is perceptually
uniform in both colour and black-and-white display is an easy option to
ensure good perceptive properties of your visulizations.
The colorspace package offers functionalities
\itemize{
\item to generate color palettes with good perceptive properties,
\item to analyse a given color palette, like emulating color blindness,
\item and to modify a given color palette for better perceptivity.
}

For more information on color vision deficiencies and suitable color choices
see the \href{https://arxiv.org/abs/1903.06490}{paper on the colorspace package}
and references therein.
}

\examples{
v <- ggplot(faithfuld, aes(waiting, eruptions, fill = density)) +
geom_tile()
v

v + scale_fill_continuous(type = "gradient")
v + scale_fill_continuous(type = "viridis")

# The above are equivalent to
v + scale_fill_gradient()
v + scale_fill_viridis_c()

# To make a binned version of this plot
v + scale_fill_binned(type = "viridis")

# Set a different default scale using the options
# mechanism
tmp <- getOption("ggplot2.continuous.fill") # store current setting
options(ggplot2.continuous.fill = scale_fill_distiller)
v
options(ggplot2.continuous.fill = tmp) # restore previous setting
}
\seealso{
\code{\link[=scale_colour_gradient]{scale_colour_gradient()}}, \code{\link[=scale_colour_viridis_c]{scale_colour_viridis_c()}},
\code{\link[=scale_colour_steps]{scale_colour_steps()}}, \code{\link[=scale_colour_viridis_b]{scale_colour_viridis_b()}}, \code{\link[=scale_fill_gradient]{scale_fill_gradient()}},
\code{\link[=scale_fill_viridis_c]{scale_fill_viridis_c()}}, \code{\link[=scale_fill_steps]{scale_fill_steps()}}, and \code{\link[=scale_fill_viridis_b]{scale_fill_viridis_b()}}

Other colour scales: 
\code{\link{scale_alpha}()},
\code{\link{scale_colour_brewer}()},
\code{\link{scale_colour_gradient}()},
\code{\link{scale_colour_grey}()},
\code{\link{scale_colour_hue}()},
\code{\link{scale_colour_steps}()},
\code{\link{scale_colour_viridis_d}()}
}
\concept{colour scales}
