% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scale-colour.r
\name{scale_colour_continuous}
\alias{scale_colour_continuous}
\alias{scale_fill_continuous}
\title{Continuous colour scales}
\usage{
scale_colour_continuous(..., type = getOption("ggplot2.continuous.colour",
  default = "gradient"))

scale_fill_continuous(..., type = getOption("ggplot2.continuous.fill", default
  = "gradient"))
}
\arguments{
\item{...}{Additional parameters passed on to the scale type}

\item{type}{One of "gradient" (the default) or "viridis" indicating the
colour scale to use}
}
\description{
Colour scales for continuous data default to the values of the
\code{ggplot2.continuous.colour} and \code{ggplot2.continuous.fill} options. If these
options are not present, \code{"gradient"} will be used. See \code{\link[=options]{options()}} for more
information.
}
\examples{
v <- ggplot(faithfuld, aes(waiting, eruptions, fill = density)) +
geom_tile()
v

v + scale_fill_continuous(type = "gradient")
v + scale_fill_continuous(type = "viridis")

# The above are equivalent to
v + scale_fill_gradient()
v + scale_fill_viridis_c()
}
\seealso{
\code{\link[=scale_colour_gradient]{scale_colour_gradient()}}, \code{\link[=scale_colour_viridis_c]{scale_colour_viridis_c()}},
\code{\link[=scale_fill_gradient]{scale_fill_gradient()}}, and \code{\link[=scale_fill_viridis_c]{scale_fill_viridis_c()}}
}
