% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stat_km_ticks.R
\name{stat_km_ticks}
\alias{stat_km_ticks}
\title{Adds Tick Marks to a Kaplan-Meier Estimate of Survival Statistic}
\usage{
stat_km_ticks(
  mapping = NULL,
  data = NULL,
  geom = "km_ticks",
  position = "identity",
  show.legend = NA,
  inherit.aes = TRUE,
  ...
)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[ggplot2:aes]{aes()}}. If specified and
\code{inherit.aes = TRUE} (the default), it is combined with the default mapping
at the top level of the plot. You must supply \code{mapping} if there is no plot
mapping.}

\item{data}{The data to be displayed in this layer. There are three
options:

If \code{NULL}, the default, the data is inherited from the plot
data as specified in the call to \code{\link[ggplot2:ggplot]{ggplot()}}.

A \code{data.frame}, or other object, will override the plot
data. All objects will be fortified to produce a data frame. See
\code{\link[ggplot2:fortify]{fortify()}} for which variables will be created.

A \code{function} will be called with a single argument,
the plot data. The return value must be a \code{data.frame}, and
will be used as the layer data. A \code{function} can be created
from a \code{formula} (e.g. \code{~ head(.x, 10)}).}

\item{geom}{The geometric object to use to display the data, either as a
\code{ggproto} \code{Geom} subclass or as a string naming the geom stripped of the
\code{geom_} prefix (e.g. \code{"point"} rather than \code{"geom_point"})}

\item{position}{Position adjustment, either as a string naming the adjustment
(e.g. \code{"jitter"} to use \code{position_jitter}), or the result of a call to a
position adjustment function. Use the latter if you need to change the
settings of the adjustment.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.
It can also be a named logical vector to finely select the aesthetics to
display.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link[ggplot2:borders]{borders()}}.}

\item{...}{Other arguments passed on to \code{\link[ggplot2:layer]{layer()}}. These are
often aesthetics, used to set an aesthetic to a fixed value, like
\code{colour = "red"} or \code{size = 3}. They may also be parameters
to the paired geom/stat.}
}
\value{
A \code{data.frame} with columns:
\itemize{
\item \code{time}: \code{time} in \code{data}.
\item \code{survival}: survival estimate at \code{time}.
\item \code{n.risk}: number of patients at risk.
\item \code{n.censor}: number of patients censored.
\item \code{n.event}: number of patients with event.
}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
This \code{stat} is for computing the location of the tick marks for the
Kaplan-Meier survival estimate for right-censored data.
It requires the aesthetic mapping \code{time} for the
observation times and \code{status} which indicates the event status,
either 0 for alive and 1 for dead, or 1 for alive and 2 for dead.
}
\note{
Logical \code{status} is not supported.
}
\examples{
library(ggplot2)
sex <- rbinom(250, 1, .5)
df <- data.frame(
  time = exp(rnorm(250, mean = sex)),
  status = rbinom(250, 1, .75),
  sex = sex
)
ggplot(df, aes(time = time, status = status, color = factor(sex))) +
  stat_km() +
  stat_km_ticks()
}
\author{
Michael Sachs (in \code{ggkm}), Samer Mouksassi (in \code{ggquickeda}).
}
