% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pathway_daa.R
\name{pathway_daa}
\alias{pathway_daa}
\title{Predictional functional patwhay differential abundance (DA)}
\usage{
pathway_daa(
  abundance,
  metadata,
  group,
  daa_method = "ALDEx2",
  select = NULL,
  p.adjust = "BH",
  reference = NULL
)
}
\arguments{
\item{abundance}{a data frame containing predicted functional pathway abundance}

\item{metadata}{a tibble containing samples information}

\item{group}{a character specifying the group name for differential abundance analysis}

\item{daa_method}{a character specifying the method for differential abundance analysis, default is "ALDEx2"}

\item{select}{a vector containing sample names for analysis, if NULL all samples are included, default is NULL}

\item{p.adjust}{a character specifying the method for p-value adjustment, default is "BH"}

\item{reference}{a character specifying the reference group level, required for several differential abundance analysis methods such as LinDA, limme voom and Maaslin2, default is NULL}
}
\value{
a data frame containing the differential abundance analysis results.
}
\description{
Predictional functional patwhay differential abundance (DA)
}
\examples{
\donttest{
library(ggpicrust2)
library(MicrobiomeStat)
abundance <- data.frame(sample1 = c(10, 20, 30),
sample2 = c(20, 30, 40),
sample3 = c(30, 40, 50),
row.names = c("pathway1", "pathway2", "pathway3"))

metadata <- tibble::tibble(sample = paste0("sample", 1:3),
group = c("control", "control", "treatment"))

#Run pathway_daa function
result <- pathway_daa(abundance = abundance, metadata = metadata, group = "group",
daa_method = "LinDA")
}
}
