% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MullerPlot.R
\name{Muller_pop_plot}
\alias{Muller_pop_plot}
\title{Draw a Muller plot of population sizes using ggplot2}
\usage{
Muller_pop_plot(Muller_df, colour_by = "Identity", palette = NA,
  add_legend = FALSE, xlab = NA, ylab = "Population")
}
\arguments{
\item{Muller_df}{Dataframe created by get_Muller_df}

\item{colour_by}{Character containing name of column by which to colour the plot}

\item{palette}{Either a brewer palette or a vector of colours (if colour_by is categorical)}

\item{add_legend}{Logical whether to show legend}

\item{xlab}{Label of x axis}

\item{ylab}{Label of y axis}
}
\value{
None
}
\description{
This variation on the Muller plot, which shows variation in population size as well as frequency, is also known as a fish plot.
}
\examples{
Muller_df <- get_Muller_df(example_edges, example_pop_df)
Muller_pop_plot(Muller_df)

}
\seealso{
\code{\link{get_Muller_df}} \code{\link{Muller_plot}}
}
\author{
Rob Noble, \email{robjohnnoble@gmail.com}
}
