% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vulkan.R
\name{ggml_vulkan_backend_name}
\alias{ggml_vulkan_backend_name}
\title{Get Vulkan backend name}
\usage{
ggml_vulkan_backend_name(backend)
}
\arguments{
\item{backend}{Vulkan backend pointer}
}
\value{
Character string with backend name
}
\description{
Returns the name of the Vulkan backend (includes device info).
}
\examples{
\donttest{
if (ggml_vulkan_available() && ggml_vulkan_device_count() > 0) {
  backend <- ggml_vulkan_init(0)
  print(ggml_vulkan_backend_name(backend))
  ggml_vulkan_free(backend)
}
}
}
