% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggs_separation.R
\name{ggs_separation}
\alias{ggs_separation}
\title{Separation plot for models with binary response variables}
\usage{
ggs_separation(
  D,
  outcome,
  minimalist = FALSE,
  show_labels = FALSE,
  uncertainty_band = TRUE
)
}
\arguments{
\item{D}{Data frame whith the simulations. Notice that only the fitted / expected posterior outcomes are needed, and so either the previous call to ggs() should have limited the family of parameters to only pass the fitted / expected values. See the example below.}

\item{outcome}{vector (or matrix or array) containing the observed outcome variable. Currently only a vector is supported.}

\item{minimalist}{logical, FALSE by default. It returns a minimalistic version of the figure with the bare minimum elements, suitable for being used inline as suggested by Greenhill, Ward and Sacks citing Tufte.}

\item{show_labels}{logical, FALSE by default. If TRUE it adds the Parameter as the label of the case in the x-axis.}

\item{uncertainty_band}{logical, TRUE by default. If FALSE it removes the uncertainty band on the predicted values.}
}
\value{
A \code{ggplot} object
}
\description{
Plot a separation plot with the results of the model against a binary response variable.
}
\examples{
data(binary)
ggs_separation(ggs(s.binary, family="mu"), outcome=y.binary)
}
\references{
Fernández-i-Marín, Xavier (2016) ggmcmc: Analysis of MCMC Samples and Bayesian Inference. Journal of Statistical Software, 70(9), 1-20. doi:10.18637/jss.v070.i09

Greenhill B, Ward MD and Sacks A (2011). The separation plot: A New Visual Method for Evaluating the Fit of Binary Models. _American Journal of Political Science_, 55(4), 991-1002, doi:10.1111/j.1540-5907.2011.00525.x.

Greenhill, Ward and Sacks (2011): The separation plot: a new visual method for evaluating the fit of binary models. American Journal of Political Science, vol 55, number 4, pg 991-1002.
}
