% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggs_autocorrelation.R
\name{ac}
\alias{ac}
\title{Calculate the autocorrelation of a single chain, for a specified amount of lags}
\usage{
ac(x, nLags)
}
\arguments{
\item{x}{Vector with a chain of simulated values.}

\item{nLags}{Numerical value with the maximum number of lags to take into account.}
}
\value{
A matrix with the autocorrelations of every chain.
}
\description{
Calculate the autocorrelation of a single chain, for a specified amount of lags.
}
\examples{
# Calculate the autocorrelation of a simple vector
ac(cumsum(rnorm(10))/10, nLags=4)
}
\references{
Fernández-i-Marín, Xavier (2016) ggmcmc: Analysis of MCMC Samples and Bayesian Inference. Journal of Statistical Software, 70(9), 1-20. doi:10.18637/jss.v070.i09
Internal function used by \code{\link{ggs_autocorrelation}}.
}

