% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/anova.R
\name{ggaov}
\alias{ggaov}
\title{Anova F test plot}
\usage{
ggaov(t, alpha=0.05, colaccept="lightsteelblue1", 
colreject="grey84", colstat="navyblue")
}
\arguments{
\item{t}{an object of class aov}

\item{alpha}{alpha level for finding critical F value}

\item{colaccept}{color for the acceptance region of the test}

\item{colreject}{color for the area of rejection of the test}

\item{colstat}{color of the statistic of the test line}
}
\description{
Visualise anova F-test to determine whether group means are equal
}
\examples{
# 21-th day
chick21 <- ChickWeight[ChickWeight$Time == 21,]
chickaov <- aov(weight~Diet, data = chick21)
summary(chickaov)

ggaov(chickaov, colaccept = "grey89", colreject = "black")

}
