% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/theme_hdx.R
\name{theme_hdx}
\alias{theme_hdx}
\title{ggplot color theme based on HDX visual design guide}
\usage{
theme_hdx(base_size = 10, base_family = "Source Sans 3", horizontal = TRUE)
}
\arguments{
\item{base_size}{base font size, given in pts.}

\item{base_family}{base font family}

\item{horizontal}{\code{logical} Horizontal axis lines?}
}
\value{
A \code{\link[ggplot2]{theme}()} to stylize a \code{ggplot2::ggplot()}
plot.
}
\description{
A theme that approximates the style of the
\emph{Humanitarian Data Exchange (HDX)}.
}
\details{
\code{theme_hdx()} implements a chart that follows the general
visual guide of the HDX platform, as defined in the
\href{https://data.humdata.org/dataviz-guide/}{dataviz-guide}.

Use \code{\link[=scale_color_hdx_discrete]{scale_color_hdx_discrete()}} with this theme.

\emph{HDX} uses two fonts in its official typography, with the free Google
font Source Sans 3 being easily available in R. Use the
\pkg{sysfonts} package to add the Google font easily.
}
\examples{
library(ggplot2)

p <- ggplot(mtcars) +
  geom_point(
    aes(
      x = mpg,
      y = hp
    )
  ) +
  labs(
    x = "Miles per gallon",
    y = "Horsepower",
    title = "Horsepower relative to miles per gallon"
  )

# the default font is source sans 3
# an error will occur if not loaded before using theme_hdx()
try(p + theme_hdx())

# you can change the base family
p + theme_hdx(base_family = "sans")

# or load Source Sans 3 using gghdx() or load_source_sans_3()
load_source_sans_3()
p + theme_hdx()

# we can change the axis line direction depending on the plot
p + theme_hdx(horizontal = FALSE)

}
\references{
\itemize{
\item \href{https://data.humdata.org}{Humanitarian Data Exchange}
\item \href{https://fonts.google.com/specimen/Source+Sans+3}{Google Fonts, Source Sans 3}
\item \href{https://data.humdata.org/dataviz-guide/}{HDX Dataviz Guide}
}
}
\seealso{
\code{\link[=gghdx]{gghdx()}} for automatically applying the theme to all plots in this
current R session, along with other styling.
}
