% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/help_secondary.R
\name{help_secondary}
\alias{help_secondary}
\title{Secondary axis helper}
\usage{
help_secondary(
  data = NULL,
  primary = c(0, 1),
  secondary = c(0, 1),
  method = c("range", "max", "fit", "ccf", "sortfit"),
  ...
)
}
\arguments{
\item{data}{A \code{data.frame} object.}

\item{primary, secondary}{An expression that is evaluated in the context of
the \code{data} argument. These can be symbols for column names or plain
expressions.}

\item{method}{One of the following: \describe{
\item{\code{"range"}}{Causes the ranges of \code{primary} and \code{secondary} data to
overlap completely.}
\item{\code{"max"}}{Causes the maxima of \code{primary} and \code{secondary} data to
coincide.}
\item{\code{"fit"}}{Uses the coefficients of \code{lm(primary ~ secondary)} to make
the axes fit.}
\item{\code{"ccf"}}{Uses the lag at which maximum cross-correlation occurs to
then align the data by truncation. The aligned data is then passed to the
\code{"fit"} method.}
\item{\code{"sortfit"}}{Sorts the both \code{primary} and \code{secondary} independently
before passing these on to the \code{"fit"} method.}
}}

\item{...}{
  Arguments passed on to \code{\link[ggplot2:sec_axis]{ggplot2::sec_axis}}
  \describe{
    \item{\code{name}}{The name of the secondary axis}
    \item{\code{breaks}}{One of:
\itemize{
\item \code{NULL} for no breaks
\item \code{waiver()} for the default breaks computed by the transformation object
\item A numeric vector of positions
\item A function that takes the limits as input and returns breaks as output
}}
    \item{\code{labels}}{One of:
\itemize{
\item \code{NULL} for no labels
\item \code{waiver()} for the default labels computed by the transformation object
\item A character vector giving labels (must be same length as \code{breaks})
\item A function that takes the breaks as input and returns labels as output
}}
    \item{\code{guide}}{A position guide that will be used to render
the axis on the plot. Usually this is \code{\link[ggplot2:guide_axis]{guide_axis()}}.}
  }}
}
\value{
An \code{AxisSecondary} ggproto object with a \code{proj} method for projecting
secondary data.
}
\description{
The purpose of this function is to construct a secondary axis with a
projection function.
}
\details{
The intent is to run this function before starting a plot. The
output of the function is a secondary axis wherein the \code{trans} argument of
\code{sec_axis()} is populated by an appropriate transformation. In addition,
the output also contains a \code{output$proj()} function that helps transform the
secondary data.
}
\examples{
# Run the secondary axis helper
sec <- help_secondary(economics, primary = unemploy, secondary = psavert)

# Making primary plot
p <- ggplot(economics, aes(date)) +
  geom_line(aes(y = unemploy), colour = "blue")

# For the secondary data, later we use the `proj` function from the helper
p <- p + geom_line(aes(y = sec$proj(psavert)), colour = "red")

# We feed the scale the secondary axis
p + scale_y_continuous(sec.axis = sec)

# Setup cross-correlated data
set.seed(42)
n <- 100
lag <- 20
dat <- cumsum(rnorm(n + lag))
df <- data.frame(
  x = seq_len(n),
  y1 = head(dat, n),
  y2 = 10 + tail(dat, n) * 5 # offset and scale y2
)
# Choosing the cross-correlation function method.
sec <- help_secondary(df, y1, y2, method = "ccf")

ggplot(df, aes(x)) +
  geom_line(aes(y = y1), colour = "blue") +
  geom_line(aes(y = sec$proj(y2)), colour = "red") +
  scale_y_continuous(sec.axis = sec)
}
