% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom-rule.r
\name{geom_rule}
\alias{geom_rule}
\title{Rulers through or offset from the origin}
\usage{
geom_rule(
  mapping = NULL,
  data = NULL,
  stat = "identity",
  position = "identity",
  axis_labels = TRUE,
  axis_ticks = TRUE,
  axis_text = TRUE,
  by = NULL,
  num = NULL,
  snap_rule = TRUE,
  tick_length = 0.025,
  text_dodge = 0.03,
  label_dodge = 0.03,
  ...,
  axis.colour = NULL,
  axis.color = NULL,
  axis.alpha = NULL,
  label.angle = 0,
  label.colour = NULL,
  label.color = NULL,
  label.alpha = NULL,
  tick.linewidth = 0.25,
  tick.colour = NULL,
  tick.color = NULL,
  tick.alpha = NULL,
  text.size = 2.6,
  text.angle = 0,
  text.hjust = 0.5,
  text.vjust = 0.5,
  text.family = NULL,
  text.fontface = NULL,
  text.colour = NULL,
  text.color = NULL,
  text.alpha = NULL,
  parse = FALSE,
  check_overlap = FALSE,
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE
)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[ggplot2:aes]{aes()}}. If specified and
\code{inherit.aes = TRUE} (the default), it is combined with the default mapping
at the top level of the plot. You must supply \code{mapping} if there is no plot
mapping.}

\item{data}{The data to be displayed in this layer. There are three
options:

If \code{NULL}, the default, the data is inherited from the plot
data as specified in the call to \code{\link[ggplot2:ggplot]{ggplot()}}.

A \code{data.frame}, or other object, will override the plot
data. All objects will be fortified to produce a data frame. See
\code{\link[ggplot2:fortify]{fortify()}} for which variables will be created.

A \code{function} will be called with a single argument,
the plot data. The return value must be a \code{data.frame}, and
will be used as the layer data. A \code{function} can be created
from a \code{formula} (e.g. \code{~ head(.x, 10)}).}

\item{stat}{The statistical transformation to use on the data for this layer.
When using a \verb{geom_*()} function to construct a layer, the \code{stat}
argument can be used the override the default coupling between geoms and
stats. The \code{stat} argument accepts the following:
\itemize{
\item A \code{Stat} ggproto subclass, for example \code{StatCount}.
\item A string naming the stat. To give the stat as a string, strip the
function name of the \code{stat_} prefix. For example, to use \code{stat_count()},
give the stat as \code{"count"}.
\item For more information and other ways to specify the stat, see the
\link[ggplot2:layer_stats]{layer stat} documentation.
}}

\item{position}{A position adjustment to use on the data for this layer. This
can be used in various ways, including to prevent overplotting and
improving the display. The \code{position} argument accepts the following:
\itemize{
\item The result of calling a position function, such as \code{position_jitter()}.
This method allows for passing extra arguments to the position.
\item A string naming the position adjustment. To give the position as a
string, strip the function name of the \code{position_} prefix. For example,
to use \code{position_jitter()}, give the position as \code{"jitter"}.
\item For more information and other ways to specify the position, see the
\link[ggplot2:layer_positions]{layer position} documentation.
}}

\item{axis_labels, axis_ticks, axis_text}{Logical; whether to include labels,
tick marks, and text value marks along the axes.}

\item{by, num}{Intervals between elements or number of elements; specify only
one.}

\item{snap_rule}{Logical; whether to snap rule segments to grid values.}

\item{tick_length}{Numeric; the length of the tick marks, as a proportion of
the minimum of the plot width and height.}

\item{text_dodge}{Numeric; the orthogonal distance of tick mark text from the
axis, as a proportion of the minimum of the plot width and height.}

\item{label_dodge}{Numeric; the orthogonal distance of the axis label from
the axis, as a proportion of the minimum of the plot width and height.}

\item{...}{Additional arguments passed to \code{\link[ggplot2:layer]{ggplot2::layer()}}.}

\item{axis.colour, axis.color, axis.alpha}{Default aesthetics for axes. Set to
NULL to inherit from the data's aesthetics.}

\item{label.angle, label.colour, label.color, label.alpha}{Default aesthetics
for labels. Set to NULL to inherit from the data's aesthetics.}

\item{tick.linewidth, tick.colour, tick.color, tick.alpha}{Default aesthetics
for tick marks. Set to NULL to inherit from the data's aesthetics.}

\item{text.size, text.angle, text.hjust, text.vjust, text.family, text.fontface, text.colour, text.color, text.alpha}{Default aesthetics for tick mark labels. Set to NULL to inherit from the
data's aesthetics.}

\item{parse}{If \code{TRUE}, the labels will be parsed into expressions and
displayed as described in \code{?plotmath}.}

\item{check_overlap}{If \code{TRUE}, text that overlaps previous text in the
same layer will not be plotted. \code{check_overlap} happens at draw time and in
the order of the data. Therefore data should be arranged by the label
column before calling \code{geom_text()}. Note that this argument is not
supported by \code{geom_label()}.}

\item{na.rm}{Passed to \code{\link[ggplot2:layer]{ggplot2::layer()}}.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.
It can also be a named logical vector to finely select the aesthetics to
display.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link[ggplot2:borders]{borders()}}.}
}
\value{
A \link[=gggda-ggproto]{ggproto} \link[ggplot2:layer]{layer}.
}
\description{
\code{geom_rule()} renders segments through or orthogonally
translated from the origin.
}
\details{
As implemented here, a rule is just an \link[=geom_axis]{axis} that has a
fixed range, usually the limits of the data. \code{geom_rule()} defaults to
\code{\link[ggplot2:stat_identity]{stat = "identity"}} to avoid the problem of
failing to pass referent data to the referential \code{\link[=stat_rule]{stat_rule()}}. Therefore,
the user must provide the \code{lower} and \code{upper} aesthetics, which are used as
euclidean lengths in the plotting window. Meanwhile, \code{stat_rule()} defaults
to \code{geom = "rule"}; see \code{\link[=stat_rule]{stat_rule()}} for details on this pairing.
}
\section{Aesthetics}{

\code{geom_rule()} understands the following aesthetics (required aesthetics are
in bold):
\itemize{
\item \strong{\code{x}}
\item \strong{\code{y}}
\item \strong{\code{lower}}
\item \strong{\code{upper}}
\item \code{yintercept} \emph{or} \code{xintercept} \emph{or} \code{xend} and \code{yend}
\item \code{linetype}
\item \code{linewidth}
\item \code{size}
\item \code{hjust}
\item \code{vjust}
\item \code{colour}
\item \code{alpha}
\item \code{label}
\item \code{family}
\item \code{fontface}
\item \code{center}, \code{scale}
\item \code{group}
}
}

\examples{
USJudgeRatings \%>\% 
  subset(select = -c(1, 12)) \%>\% 
  dist(method = "maximum") \%>\% 
  cmdscale() \%>\% 
  as.data.frame() \%>\% 
  setNames(c("PCo1", "PCo2")) \%>\% 
  transform(name = rownames(USJudgeRatings)) ->
  judge_mds
USJudgeRatings \%>\% 
  subset(select = c(CONT, RTEN)) \%>\% 
  setNames(c("contacts", "recommendation")) ->
  judge_meta
lm(as.matrix(judge_meta) ~ as.matrix(judge_mds[, seq(2)])) \%>\% 
  getElement("coefficients") \%>\% 
  unname() \%>\% t() \%>\% as.data.frame() \%>\% 
  setNames(c("Intercept", "PCo1", "PCo2")) \%>\% 
  transform(variable = names(judge_meta)) ->
  judge_lm
ggplot(judge_mds, aes(x = PCo1, y = PCo2)) +
  coord_equal() +
  theme_void() +
  geom_text(aes(label = name), size = 3) +
  stat_rule(
    data = judge_lm, referent = judge_mds,
    aes(center = Intercept, label = variable)
  )
}
\seealso{
Other geom layers: 
\code{\link{geom_axis}()},
\code{\link{geom_bagplot}()},
\code{\link{geom_isoline}()},
\code{\link{geom_lineranges}()},
\code{\link{geom_text_radiate}()},
\code{\link{geom_vector}()}
}
\concept{geom layers}
