% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fortify_basis.R
\name{fortify.basis}
\alias{fortify.basis}
\title{Convert spline basis instances to \code{data.frame}}
\usage{
\method{fortify}{basis}(model, data, n = 256, ...)
}
\arguments{
\item{model}{spline basis object}

\item{data}{x-values at which to evaluate the splines. Optional. By
default, an evenly spaced sequence of 256 values covering the
range of the splines will be used.}

\item{n}{If data is not provided, instead use an evenly-spaced
sequence of x-values of this length (plus one, since both
endpoints are included). If data is provided, this argument is
ignored.}

\item{...}{other arguments passed to methods}
}
\value{
data.frame with 3 columns: Spline (character), x (numeric),
    and y (numeric); giving the interpolated x and y values for
    each of the splines in the basis.
}
\description{
Convert spline basis instances to \code{data.frame}
}
\examples{
library(splines)
x <- seq(0, 1, by=0.001)
spl <- bs(x, df=6)
fortify(spl)
}

