% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/facet_row.R
\name{facet_row}
\alias{facet_row}
\alias{facet_col}
\title{One-dimensional facets}
\usage{
facet_row(
  facets,
  scales = "fixed",
  space = "fixed",
  shrink = TRUE,
  labeller = "label_value",
  drop = TRUE,
  strip.position = "top"
)

facet_col(
  facets,
  scales = "fixed",
  space = "fixed",
  shrink = TRUE,
  labeller = "label_value",
  drop = TRUE,
  strip.position = "top"
)
}
\arguments{
\item{facets}{A set of variables or expressions quoted by \code{\link[ggplot2:vars]{vars()}}
and defining faceting groups on the rows or columns dimension.
The variables can be named (the names are passed to \code{labeller}).

For compatibility with the classic interface, can also be a
formula or character vector. Use either a one sided formula, \code{~a + b},
or a character vector, \code{c("a", "b")}.}

\item{scales}{Should scales be fixed (\code{"fixed"}, the default),
free (\code{"free"}), or free in one dimension (\code{"free_x"},
\code{"free_y"})?}

\item{space}{Should the size of the panels be fixed or relative to the range
of the respective position scales}

\item{shrink}{If \code{TRUE}, will shrink scales to fit output of
statistics, not raw data. If \code{FALSE}, will be range of raw data
before statistical summary.}

\item{labeller}{A function that takes one data frame of labels and
returns a list or data frame of character vectors. Each input
column corresponds to one factor. Thus there will be more than
one with \code{vars(cyl, am)}. Each output
column gets displayed as one separate line in the strip
label. This function should inherit from the "labeller" S3 class
for compatibility with \code{\link[ggplot2:labeller]{labeller()}}. You can use different labeling
functions for different kind of labels, for example use \code{\link[ggplot2:label_parsed]{label_parsed()}} for
formatting facet labels. \code{\link[ggplot2:label_value]{label_value()}} is used by default,
check it for more details and pointers to other options.}

\item{drop}{If \code{TRUE}, the default, all factor levels not used in the
data will automatically be dropped. If \code{FALSE}, all factor levels
will be shown, regardless of whether or not they appear in the data.}

\item{strip.position}{By default, the labels are displayed on the top of
the plot. Using \code{strip.position} it is possible to place the labels on
either of the four sides by setting \code{strip.position = c("top",
  "bottom", "left", "right")}}
}
\description{
These facets are one-dimensional versions of \code{\link[ggplot2:facet_wrap]{ggplot2::facet_wrap()}},
arranging the panels in either a single row or a single column. This
restriction makes it possible to support a \code{space} argument as seen in
\code{\link[ggplot2:facet_grid]{ggplot2::facet_grid()}} which, if set to \code{"free"} will allow the panels to be
sized based on the relative range of their scales. Another way of thinking
about them are one-dimensional versions of \code{\link[ggplot2:facet_grid]{ggplot2::facet_grid()}} (ie.
\code{. ~ {var}} or \code{{var} ~ .}), but with the ability to position the strip at
either side of the panel. However you look at it it is the best of both world
if you just need one dimension.
}
\examples{
# Standard use
ggplot(mtcars) +
  geom_point(aes(disp, mpg)) +
  facet_col(~gear)
# It retains the ability to have unique scales for each panel
ggplot(mtcars) +
  geom_point(aes(disp, mpg)) +
  facet_col(~gear, scales = 'free')

# But can have free sizing along the stacking dimension
ggplot(mtcars) +
  geom_point(aes(disp, mpg)) +
  facet_col(~gear, scales = 'free', space = 'free')

# And you can position the strip where-ever you like
ggplot(mtcars) +
  geom_point(aes(disp, mpg)) +
  facet_col(~gear, scales = 'free', space = 'free', strip.position = 'bottom')

}
