% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geometrical_data_analysis.R
\name{ggmca_3d}
\alias{ggmca_3d}
\title{Interactive 3D Plot for Multiple Correspondence Analyses (plotly::)}
\usage{
ggmca_3d(
  res.mca,
  dat,
  cah,
  axes = 1:3,
  base_zoom = 1,
  remove_buttons = FALSE,
  cone_size = 0.15,
  view = "All",
  camera_view,
  aspectratio_from_eig = FALSE,
  title,
  ind_name.size = 10,
  max_point_size = 30,
  ...
)
}
\arguments{
\item{res.mca}{An object created with \code{FactoMineR::\link[FactoMineR]{MCA}}.}

\item{dat}{The data in which to find the cah variable, etc.}

\item{cah}{A variable made with \code{\link[FactoMineR]{HCPC}}, to link
the answers-profiles points who share the same HCPC class (will be colored
the same color and linked at mouse hover).}

\item{axes}{The axes to print, as a numeric vector of length 3.}

\item{base_zoom}{The base level of zoom.}

\item{remove_buttons}{Set to TRUE to remove buttons to change view.}

\item{cone_size}{The size of the conic arrow at the end of each axe.}

\item{view}{The starting point of view (in 3D) :
    \itemize{
  \item \code{"Plane 1-2"} : Axes 1 and 2.
  \item \code{"Plane 1-3"} : Axes 1 and 3.
  \item \code{"Plane 2-3"} : Axes 2 and 3.
  \item \code{"All"      } : A 3D perspective with Axes 1, 2, 3.
}}

\item{camera_view}{Possibility to add a (replace `view`)}

\item{aspectratio_from_eig}{Set to `TRUE` to modify axes length based on
eigenvalues.}

\item{title}{The title of the graph.}

\item{ind_name.size}{The size of the names of individuals.}

\item{max_point_size}{The size of the biggest point.}

\item{...}{Additional arguments to pass to \code{\link[ggfacto:ggmca]{ggmca}}.}
}
\value{
A \code{\link[plotly]{plotly}} html interactive 3d (or 2d) graph.
}
\description{
Interactive 3D Plot for Multiple Correspondence Analyses (plotly::)
}
\examples{
\donttest{
data(tea, package = "FactoMineR")
res.mca <- MCA2(tea, active_vars = 1:18)
ggmca_3d(res.mca)

# 3D graph with colored HCPC clusters (cah)
res.mca_3axes <- MCA2(tea, active_vars = 1:18, ncp = 3)
cah <- FactoMineR::HCPC(res.mca_3axes, nb.clust = 6, graph = FALSE)
tea$clust <- cah$data.clust$clust
ggmca_3d(res.mca, dat = tea, cah = "clust")
}
}
