% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stat-ld-annotations.R
\name{stat_ld_annotations}
\alias{stat_ld_annotations}
\title{Compute and display light/dark annotations onto a plot object}
\usage{
stat_ld_annotations(mapping = NULL, data = NULL, position = "identity",
  ld_colours = c("white", "black"), ypos = "bottom", height = 0.03,
  period = hours(24), phase = 0, l_duration = hours(12),
  outline = "black", x_limits = c(NA, NA), ..., na.rm = FALSE,
  show.legend = FALSE, inherit.aes = TRUE)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link{aes}} or
\code{\link{aes_}}. If specified and \code{inherit.aes = TRUE} (the
default), it is combined with the default mapping at the top level of the
plot. You must supply \code{mapping} if there is no plot mapping.}

\item{data}{The data to be displayed in this layer. There are three
   options:

   If \code{NULL}, the default, the data is inherited from the plot
   data as specified in the call to \code{\link{ggplot}}.

   A \code{data.frame}, or other object, will override the plot
   data. All objects will be fortified to produce a data frame. See
   \code{\link{fortify}} for which variables will be created.

   A \code{function} will be called with a single argument,
   the plot data. The return value must be a \code{data.frame.}, and
   will be used as the layer data.}

\item{position}{Position adjustment, either as a string, or the result of
a call to a position adjustment function.}

\item{ld_colours}{character vector of length two setting the
colours for light and dark phases, respectively.
The default is \code{c("white", "black")}.}

\item{ypos}{position and height of the annotation on the y axis.
It can be either \code{"top"} or \code{"bottom"}.
The default, \code{"bottom"} will put the labels below any data.}

\item{height}{relative height of the rectangles. The default is 3 percent (0.03).}

\item{period, phase, l_duration}{period, phase and duration of the L phase (in seconds) of the LD cycle.}

\item{outline}{colour of the border of the rectangles. A value of \code{NA} draws no border.}

\item{x_limits}{numerical vector of length 2 for the start and end of the annotations (in seconds).
The default, \code{c(NA, NA)}, uses the full range of the plotted data.}

\item{...}{other arguments passed on to \code{\link{layer}}. These are
often aesthetics, used to set an aesthetic to a fixed value, like
\code{color = "red"} or \code{size = 3}. They may also be parameters
to the paired geom/stat.}

\item{na.rm}{If \code{FALSE}, the default, missing values are removed with
a warning. If \code{TRUE}, missing values are silently removed.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link{borders}}.}
}
\description{
This function is used to show light and dark (L and D) phases as boxes on top a plot.
}
\examples{
library(behavr)
# We start by making a to dataset with 20 animals
metadata <- data.frame(id = sprintf("toy_experiment | \%02d", 1:20),
                   condition = c("A", "B"))
dt <- toy_activity_data(metadata, 3)
# We build a plot object
pl <-  ggetho(dt, aes(y = asleep)) + stat_pop_etho()
pl + stat_ld_annotations()
# We can also put the annotations in the background:
pl <-  ggetho(dt, aes(y = asleep)) +
                 stat_ld_annotations(outline = NA) +
                 stat_pop_etho()
pl
# Different colours (e.g. DD)
pl + stat_ld_annotations(ld_colour = c("grey", "black"))
# Shorter period
pl + stat_ld_annotations(period = hours(22), phase = hours(3))
# On a tile plot:
pl <-  ggetho(dt, aes(z = asleep)) + stat_tile_etho()
pl + stat_ld_annotations()
}
\references{
\itemize{
\item The relevant \href{https://rethomics.github.io/ggetho.html#ld-annotations}{rethomic tutorial section}
}
}
\seealso{
\itemize{
\item \link{ggetho} to generate a plot object
}

Other layers: \code{\link{geom_peak}},
  \code{\link{stat_bar_tile_etho}},
  \code{\link{stat_pop_etho}}
}
