% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloneLayer.R
\name{cloneLayer}
\alias{cloneLayer}
\title{Creates an independent copy of a ggplot layer object}
\usage{
cloneLayer(l, verbose = FALSE, showDefaults = TRUE)
}
\arguments{
\item{l}{ggplot2 object layer}

\item{verbose}{toggle to control if the output is ggproto object (verbose==FALSE,default) or string of layer call (verbose==TRUE)}

\item{showDefaults}{toggle to control if the verbose output shows all the input arguments passed to the proto object (if verbose==FALSE then ignored)}
}
\value{
ggproto or string object (conditional on verbose)
}
\description{
Creates copies of ggplot layers from within ggplot objects that
are independent of the parent object.
}
\details{
ggplot objects are comprimsed of layer objects. Once compiled they
are part of the plot object environment and if they are changed internally
regardless of where they are in the (ie different environment) it will change
the original plot. This function allows to create replicates of the plot layers
and edit them independent of the original plot. When setting verbose to TRUE
function returns the ggplot2 call as a string to paste in regular ggplot script
to generate the layer.
}
\examples{
p <- ggplot2::ggplot(iris,ggplot2::aes(x =Sepal.Length,y=Sepal.Width))

p <- p + 
ggplot2::geom_point(ggplot2::aes(colour='Species')) + 
ggplot2::geom_line()

p$layers[[1]]

newLayer <- cloneLayer(l=p$layers[[1]])

(v <- cloneLayer(l=p$layers[[1]],verbose=TRUE))

eval(parse(text=v))

}
