% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analysis.R
\name{PickStuck}
\alias{PickStuck}
\title{Which chains get stuck}
\usage{
PickStuck(x, hyper = FALSE, cut = 10, start = 1, end = NA,
  verbose = FALSE, digits = 2)
}
\arguments{
\item{x}{posterior samples}

\item{hyper}{whether x are hierarhcial samples}

\item{cut}{a criterion deciding if a chain is stuck.}

\item{start}{start to evaluate from which iteration.}

\item{end}{end at which iteration for evaeuation.}

\item{verbose}{a boolean switch to print more information}

\item{digits}{print how many digits. Default is 2}
}
\value{
\code{PickStuck} gives an index vector; \code{unstick} gives a DMC
sample.
}
\description{
Calculate each chain separately for the mean (across many MCMC iterations)
of posterior log-likelihood. If the difference of the means and
the median (across chains) of the mean of posterior is greater than the
\code{cut}, chains are considered stuck. The default value for \code{cut}
is 10. \code{unstick} manually removes stuck chains from posterior samples.
}
\examples{
model <- BuildModel(
p.map     = list(A = "1", B = "1", t0 = "1", mean_v = "M", sd_v = "1", st0 = "1"),
match.map = list(M = list(s1 = 1, s2 = 2)),
factors   = list(S = c("s1", "s2")),
constants = c(st0 = 0, sd_v = 1),
responses = c("r1", "r2"),
type      = "norm")
p.vector <- c(A = .75, B = .25, t0 = .2, mean_v.true = 2.5, mean_v.false = 1.5)

p.prior <- BuildPrior(
  dists = c("tnorm", "tnorm", "beta", "tnorm", "tnorm"),
  p1    = c(A = .3, B = .3, t0 = 1, mean_v.true = 1, mean_v.false = 0),
  p2    = c(1, 1,   1, 3, 3),
  lower = c(0,  0,  0, NA, NA),
  upper = c(NA,NA,  1, NA, NA))

\dontrun{
dat <- simulate(model, 30, ps = p.vector)
dmi <- BuildDMI(dat, model)
sam <- run(StartNewsamples(5e2, dmi, p.prior))
bad <- PickStuck(sam)
}
}
