% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{summed_log_likelihood}
\alias{summed_log_likelihood}
\alias{summed_log_likelihood_parallel}
\title{Sum and Log Probability Density of a EAM model}
\usage{
summed_log_likelihood(pVec, data)

summed_log_likelihood_parallel(pVec, data)
}
\arguments{
\item{pVec}{a parameter vector}

\item{data}{a model data instance
argument.}
}
\value{
a double scalar
}
\description{
Get log likelihood summed over a model data instance.  The input data has
to be a data frame carrying a model specification, which is usually
created by \code{model.data.dmc} function.
\code{summed_log_likelihood_parallel} does calculation in parallel. Use it
when only the data set is big.
}
\examples{
m1 <- model.dmc(
  p.map     = list(a="1", v="1", z="1", d="1", sz="1", sv="1", t0="1", st0="1"),
  constants = c(st0=0, d=0),
  match.map = list(M=list(s1="r1", s2="r2")),
  factors   = list(S=c("s1", "s2")),
  responses = c("r1", "r2"),
  type      = "rd")

pVec <- c(a=1, v=1, z=0.5, sz=0.25, sv=0.2,t0=.15)

## Set up a model-data instance
dat <- simulate(m1, nsim=1e2, p.vector=pVec)
mdi <- data.model.dmc(dat, m1)
summed_log_likelihood(pVec, mdi)
## [1] 0.3796048
}

