% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggdmc_plotting.R
\name{plot.dmc.list}
\alias{plot.dmc.list}
\title{Plot a DMC Sample with Multiple Participants}
\usage{
\method{plot}{dmc.list}(x, y = NULL, start = 1, end = NA,
  save.ll = FALSE, main.pll = NULL, pll.chain = FALSE,
  pll.together = TRUE, pll.barplot = FALSE, only.prior = FALSE,
  only.like = FALSE, smooth = FALSE, density = FALSE, save.dat = FALSE,
  p.prior = NULL, natural = TRUE, trans = NA, xlim = NA,
  chain1 = TRUE, subject = 1, ...)
}
\arguments{
\item{x}{a \code{run.dmc} or \code{samples.dmc} generated model samples}

\item{y}{default NULL. No function. Just to make it compatible to
\code{plot}}

\item{start}{instruct the function to plot starting from which iteration.
This indicates how many burn-in interations one requests. For example,
start=101, indicates 100 burn-in interations.}

\item{end}{instruct the function to plot ending at a certain iteration}

\item{save.ll}{a boolean switch to tell the function to save the mean
log-likelihood. This option does not work in DMC's plot.dmc, too.}

\item{main.pll}{a string as the title for the boxplot. Default is NULL}

\item{pll.chain}{a boolean switch to plot posterior log likelihoood}

\item{pll.together}{a boolean switch to plot the posterior log-likelihood
chains all together in one canvar}

\item{pll.barplot}{a boolean switch to plot the means of posterior
log-likelihood of all chains as a barplot. By default, it is off.}

\item{only.prior}{Default is FALSE}

\item{only.like}{Default is FALSE. only.prior and only.like two switches
to plot only prior density or only log-likelihood probability.}

\item{smooth}{default FALSE}

\item{density}{plot probability density together with trace? Default FALSE}

\item{save.dat}{whether save the internal data table out for polish plots}

\item{p.prior}{prior distribution setting. necessary for plot.prior to work}

\item{natural}{additional argument for plot.prior}

\item{trans}{additional argument for plot.prior}

\item{xlim}{additional argument for plot.prior}

\item{chain1}{plot all chains or just chain1}

\item{subject}{which subject in the list to plot. Default the 1st one.}

\item{...}{other arguments}
}
\description{
Plot trace and probability desntiy, using a model samples. This function
taks a sample list.
}
\examples{
m1 <- model.dmc(
p.map     = list(a="1",v="1",z="1",d="1",sz="1",sv="1",t0="1",st0="1"),
match.map = list(M=list(s1="r1", s2="r2")),
factors   = list(S=c("s1", "s2")),
constants = c(st0=0, d=0),
responses = c("r1","r2"),
type      = "rd")

## Population distribution
pop.prior <- prior.p.dmc(
  dists = rep("tnorm", 6),
  p1    = c(a=2,   v=2.5, z=0.5, sz=0.3, sv=1,  t0=0.3),
  p2    = c(a=0.5, v=.5,  z=0.1, sz=0.1, sv=.3, t0=0.05),
  lower = c(0,-5, 0, 0, 0, 0),
  upper = c(5, 7, 2, 2, 2, 2))

dat <- h.simulate.dmc(m1, p.prior=pop.prior, n=50, ns=4)
mdi <- data.model.dmc(dat, m1)
p.prior  <- prior.p.dmc(
  dists = rep("tnorm", 6),
  p1    = c(a=2,   v=2.5, z=0.5, sz=0.3, sv=1,  t0=0.3),
  p2    = c(a=0.5, v=.5,  z=0.1, sz=0.1, sv=.3, t0=0.05) * 5,
  lower = c(0,-5, 0, 0, 0, 0),
  upper = c(5, 7, 2, 2, 2, 2))

## Fixed-effect model
samplesInit <- h.samples.dmc(nmc=50, p.prior=p.prior, data=mdi, thin=1)
samples0    <- h.run.dmc(samples=samplesInit, report=25)
## Windows tests produce a grid.Call problem. The user should use
## with caution.
## plot(samples0) ## traceplot for the first participant
## plot(samples0, density=TRUE)  ## trace- and density-plot
## plot(samples0, density=TRUE, subject=2) ## Plot second participant
## plot(samples0, density=TRUE, subject=3, start=101) ## From 101 iteration
## Plot iteratoin 201 to 400
## plot(samples0, density=TRUE, subject=4, start=201, end=400)
}

