% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_dendrogram.R
\name{move_dendrogram}
\alias{move_dendrogram}
\title{Move coordinates of dendrogram to edges of heatmap}
\usage{
move_dendrogram(
  dend_seg,
  x_long,
  context = c("rows", "cols"),
  dend_side,
  dend_dist,
  annot_df,
  annot_side,
  annot_pos,
  annot_size
)
}
\arguments{
\item{dend_seg}{Data frame containing dendrogram segments, attained from \code{dendextend::as.ggdend()}}

\item{x_long}{Long format data frame with the values}

\item{context}{Character specifying whether the dendrogram is linked to rows or columns in the heatmap}

\item{dend_side}{Logical specifying dendrogram position. TRUE is left of the heatmap if row dendrogram, bottom of heatmap if column dendrogram}

\item{dend_dist}{Distance from heatmap (or annotation) to dendrogram in cell size.}

\item{annot_df}{Data frame with annotations for checking that annotations exist as well as their size}

\item{annot_side}{Logical specifying annotation position, analogous to \code{dend_side}}

\item{annot_pos}{Numeric vector of annotation coordinates (x coordinates for row annotations, y for column annotations)}

\item{annot_size}{Numeric of length 1, the specified size (width or height) of annotation cells}
}
\value{
Data frame with updated dendrogram coordinates
}
\description{
Move coordinates of dendrogram by calculating distance it has to move to end up at the desired edges of the heatmap
}
\keyword{internal}
