% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_mixed_layout.R
\name{add_mixed_layout}
\alias{add_mixed_layout}
\title{Add a layout column to long format data for mixed layouts.}
\usage{
add_mixed_layout(
  x,
  rows = "row",
  cols = "col",
  values = "value",
  layout,
  name = "layout"
)
}
\arguments{
\item{x}{Long format data frame of a symmetric matrix.}

\item{rows, cols, values}{Columns containing rows, columns, and values.}

\item{layout}{Character vector of length two with a mixed layout (two opposing triangles).}

\item{name}{Name of the column that should contain the layouts.}
}
\value{
The input data frame with a new column added, showing in which triangle each value would be in a mixed layout.
}
\description{
Add a layout column to long format data for mixed layouts.
}
\examples{
# Make long format symmetric data
long_df <- data.frame(rw = rep(letters[1:4], 4),
                      cl = rep(letters[1:4], each = 4),
                      val = 0)

long_df <- add_mixed_layout(long_df, rw, cl, val,
                            layout = c("topleft", "bottomright"))

head(long_df)

}
