% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/approx_match.R
\name{get_analogue}
\alias{get_analogue}
\title{return resulted strings of approximate string match}
\usage{
get_analogue(fuzzy_input = "axs.txt", possibilities = c("axis.text",
  "axis.text.x"), n_top = 5, case_sensitive = FALSE, cost = c(insertions =
  0.25, deletions = 3, substitutions = 2), threshold = 6, debug = FALSE)
}
\arguments{
\item{fuzzy_input}{A character. Typically user input.}

\item{possibilities}{A character vector one of which
is assumed to be pointed by fuzzy_input.}

\item{n_top}{An integer specifying the number of returned strings.}

\item{case_sensitive}{Default is FALSE.}

\item{cost}{A named vector}

\item{threshold}{If costs are more than threshold,
remove them from the result
even if they are within top \code{n_top}.
Default is 6.}

\item{debug}{If true, it shows costs for top candidates.

\code{get_analogue} is a key function
for returning useful compile error message.}
}
\description{
return resulted strings of approximate string match
}
\examples{

get_analogue("axis.txt", c("axis.text", "axis.text.x", "axis.ticks"))
# returns "axis.text" "axis.text.x" "axis.ticks"

get_analogue("p.bg", c("plot.background", "panel.background"))
# returns "plot.background" as first, and then "panel.background"


}
