% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sugar.R
\name{montage}
\alias{montage}
\title{Convenience function to add many slices in a montage along one of the 3D planes}
\usage{
montage(
  plane = NULL,
  n = 12,
  min = 0.1,
  max = 0.9,
  min_coord = NULL,
  max_coord = NULL
)
}
\arguments{
\item{plane}{a character string specifying the 3D plane: "sagittal", "axial", "coronal", "x", "y", or "z"}

\item{n}{number of slices to add in this plane. Default: 12}

\item{min}{the lowest quantile to be included in the montage (between 0 and 1). Default: 0.1}

\item{max}{the highest quantile to be included in the montage (between 0 and 1). Default: 0.9}

\item{min_coord}{the lowest spatial position (in image coordinate space) to be included in the montage.}

\item{max_coord}{the highest spatial position (in image coordinate space) to be included in the montage.}
}
\value{
a character string containing the slice positions along the requested axis
}
\description{
Convenience function to add many slices in a montage along one of the 3D planes
}
\details{
This can be used with \code{slices} to make a quick montage, such as \verb{slices(montage("axial", 10)}.

Also note that use of standardized coordinates (in quantiles, using \code{min} and \code{max}) is mutually exclusive
with the the image coordinate specifications \code{min_coord} and \code{max_coord.}
}
\examples{
  t1 <- system.file("extdata", "mni_template_2009c_2mm.nii.gz", package = "ggbrain")
  gg_obj <- ggbrain() +
    images(c(underlay = t1)) +
    slices(montage("sagittal", 15))
}
