% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{find_threads}
\alias{find_threads}
\title{This function finds 'threads' hanging off of the edges of blobs in an image, allowing the user to trim them}
\arguments{
\item{im}{A numeric matrix representing an image, with non-zero values representing pixels to display}

\item{min_neighbors}{the minimum number of neighbors a pixel must have to be retained}

\item{maxit}{the maximum number of iterations to run the thread trimming algorithm. Default: 15.}

\item{diagonal}{Whether to count diagonal elements as valid neighbors}
}
\value{
A logical matrix matrix of the same size as \code{im} containing the number of neighboring pixels
}
\description{
This function finds 'threads' hanging off of the edges of blobs in an image, allowing the user to trim them
}
\details{
This algorithm runs count_neighbors iteratively until no pixel exceeds the trimming threshold \code{min_neighbors}
or the maximum number of iterations, \code{maxit}, is reached.

By running iteratively, long tails are trimmed sequentially by pruning the most disconnected voxels.
}
\author{
Michael Hallquist
}
