% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gg_freqpoly.R
\name{gg_freqpoly}
\alias{gg_freqpoly}
\title{Freqpoly ggplot}
\usage{
gg_freqpoly(
  data = NULL,
  x = NULL,
  y = NULL,
  col = NULL,
  facet = NULL,
  facet2 = NULL,
  group = NULL,
  text = NULL,
  mapping = NULL,
  stat = "bin",
  position = "identity",
  coord = ggplot2::coord_cartesian(clip = "off"),
  pal = NULL,
  pal_na = pal_grey,
  alpha = 1,
  ...,
  title = NULL,
  subtitle = NULL,
  x_breaks = NULL,
  x_expand = NULL,
  x_gridlines = NULL,
  x_include = NULL,
  x_labels = NULL,
  x_limits = NULL,
  x_oob = scales::oob_keep,
  x_sec_axis = ggplot2::waiver(),
  x_title = NULL,
  x_trans = "identity",
  y_breaks = NULL,
  y_expand = NULL,
  y_gridlines = NULL,
  y_include = NULL,
  y_labels = NULL,
  y_limits = NULL,
  y_oob = scales::oob_keep,
  y_sec_axis = ggplot2::waiver(),
  y_title = NULL,
  y_trans = "identity",
  col_breaks = NULL,
  col_continuous = "gradient",
  col_include = NULL,
  col_labels = NULL,
  col_legend_place = NULL,
  col_legend_ncol = NULL,
  col_legend_nrow = NULL,
  col_legend_rev = FALSE,
  col_limits = NULL,
  col_oob = scales::oob_keep,
  col_rescale = scales::rescale(),
  col_title = NULL,
  col_trans = "identity",
  facet_labels = NULL,
  facet_ncol = NULL,
  facet_nrow = NULL,
  facet_scales = "fixed",
  facet_space = "fixed",
  facet_layout = NULL,
  facet_switch = NULL,
  linetype_title = NULL,
  shape_title = NULL,
  size_title = NULL,
  caption = NULL,
  titles = snakecase::to_sentence_case,
  theme = NULL
)
}
\arguments{
\item{data}{A data frame or tibble.}

\item{x}{Unquoted x aesthetic variable.}

\item{y}{Unquoted y aesthetic variable.}

\item{col}{Unquoted col and fill aesthetic variable.}

\item{facet}{Unquoted facet aesthetic variable.}

\item{facet2}{Unquoted second facet variable.}

\item{group}{Unquoted group aesthetic variable.}

\item{text}{Unquoted text aesthetic variable.}

\item{mapping}{Map additional aesthetics using the ggplot2::aes function (e.g. shape). Excludes colour, fill or alpha.}

\item{stat}{A ggplot2 character string stat.}

\item{position}{Position adjustment. Either a character string (e.g."identity"), or a function (e.g. ggplot2::position_identity()).}

\item{coord}{A coordinate function from ggplot2 (e.g. ggplot2::coord_cartesian(clip = "off")).}

\item{pal}{Colours to use. A character vector of hex codes (or names).}

\item{pal_na}{Colour to use for NA values. A character vector of a hex code (or name).}

\item{alpha}{Opacity. A number between 0 and 1.}

\item{...}{Other arguments passed to the ggplot2::geom_freqpoly function.}

\item{title}{Title string.}

\item{subtitle}{Subtitle string.}

\item{x_breaks}{A scales::breaks_* function (e.g. scales::breaks_pretty()), or a vector of breaks.}

\item{x_expand}{Padding to the limits with the ggplot2::expansion function, or a vector of length 2 (e.g. c(0, 0)).}

\item{x_gridlines}{TRUE or FALSE for vertical x gridlines. NULL guesses based on the classes of the x and y.}

\item{x_include}{For a continuous x variable, any values that the limits should encompass (e.g. 0).}

\item{x_labels}{A function that takes the breaks as inputs (e.g. scales::label_comma()), or a vector of labels.}

\item{x_limits}{A vector of length 2 to determine the limits of the axis.}

\item{x_oob}{For a continuous x variable, a scales::oob_* function of how to handle values outside of limits (e.g. scales::oob_keep). Defaults to scales::oob_keep.}

\item{x_sec_axis}{A secondary axis using the ggplot2::sec_axis or ggplot2::dup_axis function.}

\item{x_title}{Axis title string. Use "" for no title.}

\item{x_trans}{For a numeric x variable, a transformation object (e.g. "log10", "sqrt" or "reverse").}

\item{y_breaks}{A scales::breaks_* function (e.g. scales::breaks_pretty()), or a vector of breaks.}

\item{y_expand}{Padding to the limits with the ggplot2::expansion function, or a vector of length 2 (e.g. c(0, 0)).}

\item{y_gridlines}{TRUE or FALSE of horizontal y gridlines. NULL guesses based on the classes of the x and y.}

\item{y_include}{For a continuous y variable, any values that the limits should encompass (e.g. 0).}

\item{y_labels}{A function that takes the breaks as inputs (e.g. scales::label_comma()), or a vector of labels.}

\item{y_limits}{A vector of length 2 to determine the limits of the axis.}

\item{y_oob}{For a continuous y variable, a scales::oob_* function of how to handle values outside of limits (e.g. scales::oob_keep). Defaults to scales::oob_keep.}

\item{y_sec_axis}{A secondary axis using the ggplot2::sec_axis or ggplot2::dup_axis function.}

\item{y_title}{Axis title string. Use "" for no title.}

\item{y_trans}{For a numeric y variable, a transformation object (e.g. "log10", "sqrt" or "reverse").}

\item{col_breaks}{A scales::breaks_* function (e.g. scales::breaks_pretty()), or a vector of breaks.}

\item{col_continuous}{For a continuous col variable, the type of colouring. Either "gradient" or "steps". Defaults to "gradient".}

\item{col_include}{For a continuous col variable, any values that the limits should encompass (e.g. 0).}

\item{col_labels}{A function that takes the breaks as inputs (e.g. scales::label_comma()), or a vector of labels.}

\item{col_legend_place}{The place for the legend. Either "bottom", "right", "top" or "left". Or just the first letter of each.}

\item{col_legend_ncol}{The number of columns for the legend elements.}

\item{col_legend_nrow}{The number of rows for the legend elements.}

\item{col_legend_rev}{Reverse the elements of the legend. Defaults to FALSE.}

\item{col_limits}{A vector to determine the limits of the colour scale.}

\item{col_oob}{For a continuous col variable, a scales::oob_* function of how to handle values outside of limits (e.g. scales::oob_keep). Defaults to scales::oob_keep.}

\item{col_rescale}{For a continuous col variable, a scales::rescale function.}

\item{col_title}{Legend title string. Use "" for no title.}

\item{col_trans}{For a numeric col variable, a transformation object (e.g. "log10", "sqrt" or "reverse").}

\item{facet_labels}{A function that takes the breaks as inputs (e.g. scales::label_comma()), or a named vector of labels (e.g. c("value" = "label", ...)).}

\item{facet_ncol}{The number of columns of facets. Only applies to a facet layout of "wrap".}

\item{facet_nrow}{The number of rows of facets. Only applies to a facet layout of "wrap".}

\item{facet_scales}{Whether facet scales should be "fixed" across facets, "free" in both directions, or free in just one direction (i.e. "free_x" or "free_y"). Defaults to "fixed".}

\item{facet_space}{Whether facet space should be "fixed" across facets, "free" to be proportional in both directions, or free to be proportional in just one direction (i.e. "free_x" or "free_y"). Defaults to "fixed". Only applies where the facet layout is "grid" and facet scales are not "fixed".}

\item{facet_layout}{Whether the layout is to be "wrap" or "grid". If NULL and a single facet (or facet2) argument is provided, then defaults to "wrap". If NULL and both facet and facet2 arguments are provided, defaults to "grid".}

\item{facet_switch}{Whether the facet layout is "grid", whether to switch the facet labels to the opposite side of the plot. Either "x", "y" or "both".}

\item{linetype_title}{Legend title string. Use "" for no title.}

\item{shape_title}{Legend title string. Use "" for no title.}

\item{size_title}{Legend title string. Use "" for no title.}

\item{caption}{Caption title string.}

\item{titles}{A function to format unspecified titles. Defaults to snakecase::to_sentence_case.}

\item{theme}{A ggplot2 theme.}
}
\value{
A ggplot object.
}
\description{
Create a freqpoly ggplot with a wrapper around ggplot2::geom_freqpoly(stat = "bin", ...).
}
\examples{
library(dplyr)
library(palmerpenguins)

penguins |>
  tidyr::drop_na(sex) |>
  gg_freqpoly(
    x = flipper_length_mm,
    col = sex,
    facet = species,
    pal = c("#1B9E77", "#9E361B"),
    col_labels = stringr::str_to_sentence
  )

}
