% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aes.R
\name{aes_colour_contrast}
\alias{aes_colour_contrast}
\title{A colour aesthetic for contrast}
\usage{
aes_colour_contrast(..., dark = "#121B24FF", light = "#FFFFFFFF")
}
\arguments{
\item{...}{Provided to force user argument naming etc.}

\item{dark}{A dark colour.}

\item{light}{A light colour.}
}
\value{
A ggplot2 aesthetic
}
\description{
A colour aesthetic to contrast with a fill aesthetic. Can be spliced into \link[ggplot2:aes]{ggplot2::aes} with \link[rlang:splice-operator]{rlang::!!!}.
}
\examples{
library(ggplot2)
library(dplyr)
library(stringr)
library(palmerpenguins)

set_blanket()

penguins |>
  count(species, sex) |>
  gg_col(
    x = sex,
    y = n,
    col = species,
    label = n,
    position = position_dodge(preserve = "single"),
    width = 0.75,
    x_labels = \(x) str_to_sentence(x),
  ) +
  geom_text(
    mapping = aes_colour_contrast(),
    position = position_dodge(width = 0.75, preserve = "single"),
    vjust = 1.33,
    show.legend = FALSE,
  )

penguins |>
  count(species, sex) |>
  gg_col(
    x = sex,
    y = n,
    col = species,
    position = position_dodge(preserve = "single"),
    width = 0.75,
    x_labels = \(x) str_to_sentence(x),
    mode = dark_mode_r(),
  ) +
  geom_text(
    mapping = aes(label = n, !!!aes_colour_contrast(dark = darkness[3], light = darkness[1])),
    position = position_dodge(width = 0.75, preserve = "single"),
    vjust = 1.33,
    show.legend = FALSE,
  )
}
