% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggscreeplot.R
\name{ggscreeplot}
\alias{ggscreeplot}
\title{Screeplot for Principal Components}
\usage{
ggscreeplot(pcobj, type = c("pev", "cev"), size = 4)
}
\arguments{
\item{pcobj}{an object representing a linear dimension technique, such a returned by \code{\link[stats]{prcomp}} 
or \code{\link[stats]{princomp}} or \code{\link[FactoMineR]{PCA}} or \code{\link[MASS]{lda}}}

\item{type}{the type of scree plot.
'pev' corresponds proportion of explained variance, i.e. the eigenvalues divided by the trace. 
'cev' corresponds to the cumulative proportion of explained variance, i.e. the partial sum of the first k eigenvalues divided by the trace.}

\item{size}{point size}
}
\value{
A ggplot2 object
}
\description{
Produces scree plots (Cattell, 1966) of the variance proportions explained by each dimension against dimension number from 
various dimension reduction techniques
}
\examples{
  data(wine)
  wine.pca <- prcomp(wine, scale. = TRUE)
  ggscreeplot(wine.pca)

}
\references{
Cattell, R. B. (1966). The Scree Test For The Number Of Factors. \emph{Multivariate Behavioral Research}, 1, 245–276.
}
